/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.listeners;

import com.google.common.collect.Lists;
import com.nordstrom.automation.testng.ListenerChain;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IConfigurationListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;

public class CarinaListenerChain
extends ListenerChain {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void beforeConfiguration(ITestResult tr, ITestNGMethod tm) {
        try {
            Field configListenersField = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("configListeners");
            configListenersField.setAccessible(true);
            List listeners = (List)configListenersField.get((Object)this);
            this.invokeListeners(tr, tm, listeners);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Could not invoke configuration listeners.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeListeners(ITestResult tr, ITestNGMethod tm, List<IConfigurationListener> listeners) {
        List<IConfigurationListener> list = listeners;
        synchronized (list) {
            for (IConfigurationListener configListener : Lists.reverse(listeners)) {
                configListener.beforeConfiguration(tr, tm);
            }
        }
    }
}

