/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.listeners;

import com.qaprosoft.carina.core.foundation.filter.Filter;
import com.qaprosoft.carina.core.foundation.filter.IFilter;
import com.qaprosoft.carina.core.foundation.filter.rule.Rule;
import com.qaprosoft.carina.core.foundation.utils.Configuration;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestNGMethod;

public class FilterTestsListener
implements ISuiteListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private List<Rule> rules = new ArrayList<Rule>();

    public void onStart(ISuite suite) {
        this.rules = this.parseRules(Configuration.get((Configuration.Parameter)Configuration.Parameter.TEST_RUN_RULES));
        if (this.rules.isEmpty()) {
            LOGGER.debug("There are no any rules and limitations");
            return;
        }
        LOGGER.info("Extracted rules: ".concat(this.rules.toString()));
        for (ITestNGMethod testMethod : suite.getAllMethods()) {
            boolean isPerform = true;
            for (Rule rule : this.rules) {
                if (!isPerform) break;
                isPerform = rule.getTestFilter().isPerform(testMethod, rule.getRuleExpression());
            }
            if (isPerform) continue;
            this.disableTest(testMethod);
        }
    }

    public void onFinish(ISuite suite) {
    }

    private void disableTest(ITestNGMethod testMethod) {
        LOGGER.info(String.format("Disable test: [%s]", testMethod.getMethodName()));
        testMethod.setInvocationCount(0);
    }

    private List<Rule> parseRules(String ruleStr) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (!ruleStr.isEmpty()) {
            LOGGER.info("Rules for suite limitation have been defined.");
            if (ruleStr.contains("&amp;&amp;")) {
                ruleStr = ruleStr.replaceAll("&amp;&amp;", "&&");
            }
            for (String ruleItem : ruleStr.split(";;")) {
                String[] ruleStructure = ruleItem.split("=>");
                if (ruleStructure.length != 2) continue;
                List<String> priority = this.prioritize(ruleStructure[1]);
                IFilter filter = Filter.getRuleByName(ruleStructure[0]).getFilter();
                rules.add(new Rule(ruleStructure[0], filter, priority));
            }
        }
        return rules;
    }

    private List<String> prioritize(String ruleStr) {
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(ruleStr.split("(?=&&)|(?=\\|\\|)")));
        return values;
    }
}

