/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.skip;

import com.qaprosoft.carina.core.foundation.rule.IRule;
import com.qaprosoft.carina.core.foundation.skip.ExpectedSkip;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;

public class ExpectedSkipManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static ExpectedSkipManager instance = null;

    private ExpectedSkipManager() {
    }

    public static synchronized ExpectedSkipManager getInstance() {
        if (null == instance) {
            instance = new ExpectedSkipManager();
        }
        return instance;
    }

    public boolean isSkip(Method testMethod, ITestContext context) {
        for (Class<? extends IRule> rule : this.collectRules(testMethod, context)) {
            try {
                if (!rule.newInstance().isPerform()) continue;
                LOGGER.info("Test execution will be skipped due to following rule: ".concat(rule.getName()));
                return true;
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error("Error during skip rules initialization: ".concat(rule.getName()));
                LOGGER.error("Error msg: ", (Throwable)e);
            }
        }
        return false;
    }

    private List<Class<? extends IRule>> collectRules(Method testMethod, ITestContext context) {
        ITestNGMethod[] methods;
        ArrayList<Class<? extends IRule>> rules = new ArrayList<Class<? extends IRule>>();
        ExpectedSkip classSkipAnnotation = testMethod.getDeclaringClass().getAnnotation(ExpectedSkip.class);
        ExpectedSkip methodSkipAnnotation = testMethod.getAnnotation(ExpectedSkip.class);
        rules.addAll(this.getRulesFromAnnotation(classSkipAnnotation));
        rules.addAll(this.getRulesFromAnnotation(methodSkipAnnotation));
        for (ITestNGMethod iTestNGMethod : methods = context.getAllTestMethods()) {
            String[] methodsDep;
            if (!iTestNGMethod.getMethodName().equalsIgnoreCase(testMethod.getName())) continue;
            for (String method : methodsDep = iTestNGMethod.getMethodsDependedUpon()) {
                rules.addAll(this.getDependentMethodsRules(method));
            }
        }
        return rules;
    }

    private List<Class<? extends IRule>> getRulesFromAnnotation(ExpectedSkip annotation) {
        ArrayList<Class<? extends IRule>> rules = new ArrayList<Class<? extends IRule>>();
        if (annotation != null) {
            rules.addAll(Arrays.asList(annotation.rules()));
        }
        return rules;
    }

    private List<Class<? extends IRule>> getDependentMethodsRules(String methodName) {
        int indexDot = methodName.lastIndexOf(".");
        String clazz = methodName.substring(0, indexDot);
        String shortName = methodName.substring(indexDot + 1);
        ArrayList<Class<? extends IRule>> rules = new ArrayList<Class<? extends IRule>>();
        try {
            Method[] methods;
            LOGGER.debug("Extracted class name: ".concat(clazz));
            Class<?> testClass = Class.forName(clazz);
            if (testClass.isAnnotationPresent(ExpectedSkip.class)) {
                LOGGER.debug("Class is annotated with @ExpectedSkip: ".concat(clazz));
                rules.addAll(Arrays.asList(testClass.getAnnotation(ExpectedSkip.class).rules()));
            }
            for (Method method : methods = testClass.getDeclaredMethods()) {
                if (!shortName.equalsIgnoreCase(method.getName()) || !method.isAnnotationPresent(ExpectedSkip.class)) continue;
                LOGGER.debug("Method is annotated with @ExpectedSkip: ".concat(methodName));
                rules.addAll(Arrays.asList(method.getAnnotation(ExpectedSkip.class).rules()));
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Error during class initialization: ".concat(e.getMessage()));
        }
        return rules;
    }
}

