/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.retry;

import com.qaprosoft.carina.core.foundation.jira.Jira;
import com.qaprosoft.carina.core.foundation.retry.RetryCounter;
import com.qaprosoft.carina.core.foundation.utils.Configuration;
import org.testng.IRetryAnalyzer;
import org.testng.ITestResult;

public class RetryAnalyzer
implements IRetryAnalyzer {
    public boolean retry(ITestResult result) {
        if (RetryCounter.getRunCount() < RetryAnalyzer.getMaxRetryCountForTest() && !Jira.isRetryDisabled(result)) {
            RetryCounter.incrementRunCount();
            return true;
        }
        return false;
    }

    public static int getMaxRetryCountForTest() {
        return Configuration.getInt(Configuration.Parameter.RETRY_COUNT);
    }
}

