/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

public class ZipManager {
    private static final Logger LOGGER = Logger.getLogger(ZipManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String zip, String extractTo) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    File folder = new File(extractTo + "/" + entry.getName());
                    boolean isCreated = folder.mkdir();
                    if (isCreated) continue;
                    throw new RuntimeException("Folder not created: " + folder.getAbsolutePath());
                }
                InputStream is = zipFile.getInputStream(entry);
                try (FileOutputStream fos = new FileOutputStream(extractTo + "/" + entry.getName());
                     BufferedOutputStream bos = new BufferedOutputStream(fos);){
                    ZipManager.copyInputStream(is, bos);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        if (in == null) {
            return;
        }
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }
}

