/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.android;

import com.google.common.base.Function;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.FluentWait;

public class ToastDetector
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ToastDetector.class);
    private static final String TOAST_PATTERN = "//*[@text='%s']";
    private boolean isPresent = false;
    private int waitTimeout = 20;
    private WebDriver webDriver;
    private String toastToWait;

    public ToastDetector(WebDriver webDriver, String toastToWait) {
        this.webDriver = webDriver;
        this.toastToWait = toastToWait;
    }

    public void setToastToWait(String toastToWait) {
        this.toastToWait = toastToWait;
    }

    public void setWaitTimeout(int waitTimeout) {
        if (waitTimeout > 60) {
            LOGGER.warn((Object)"Max wait timeout 60 second!");
            this.waitTimeout = 60;
            return;
        }
        this.waitTimeout = waitTimeout;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    @Override
    public void run() {
        this.waitForToast();
    }

    private void waitForToast() {
        LOGGER.info((Object)"Wait for toast...");
        this.isPresent = false;
        FluentWait fluentWait = new FluentWait((Object)this.webDriver);
        fluentWait.withTimeout((long)this.waitTimeout, TimeUnit.SECONDS).pollingEvery(300L, TimeUnit.MILLISECONDS).until((java.util.function.Function)new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver input) {
                List webElemenList = ToastDetector.this.webDriver.findElements(By.xpath((String)String.format(ToastDetector.TOAST_PATTERN, ToastDetector.this.toastToWait)));
                if (webElemenList.size() == 1) {
                    LOGGER.info((Object)("Toast with text present: " + ToastDetector.this.toastToWait));
                    ToastDetector.this.isPresent = true;
                    return true;
                }
                return false;
            }
        });
    }

    public void startFinding() {
        Thread thread = new Thread(this);
        try {
            thread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

