/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.async;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class AsyncOperation {
    private static final Logger LOGGER = Logger.getLogger(AsyncOperation.class);
    private static Set<CompletableFuture<?>> asyncOperations;

    public static void add(CompletableFuture<?> ... completableFutures) {
        LOGGER.debug((Object)"Async operations adding");
        AsyncOperation.get().addAll(Arrays.asList(completableFutures));
    }

    public static void add(CompletableFuture<?> completableFuture) {
        LOGGER.debug((Object)"Async operation adding");
        AsyncOperation.get().add(completableFuture);
    }

    public static void waitUntilFinish(long timeout) {
        try {
            if (asyncOperations != null && !asyncOperations.isEmpty()) {
                CompletableFuture.allOf(AsyncOperation.get().toArray(new CompletableFuture[0])).get(timeout, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            AsyncOperation.clear();
        }
    }

    private static Set<CompletableFuture<?>> get() {
        if (asyncOperations == null) {
            asyncOperations = Collections.synchronizedSet(new HashSet());
        }
        return asyncOperations;
    }

    private static void clear() {
        if (asyncOperations != null) {
            asyncOperations = null;
        }
    }
}

