/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.naming;

import com.qaprosoft.carina.core.foundation.retry.RetryCounter;
import com.qaprosoft.carina.core.foundation.utils.Configuration;
import java.util.Arrays;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;

public class TestNamingUtil {
    private static final Logger LOGGER = Logger.getLogger(TestNamingUtil.class);
    private static final ConcurrentHashMap<Long, Stack<String>> threadId2TestName = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Integer> testName2Counter = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> testName2Bug = new ConcurrentHashMap();

    public static synchronized String associateTestInfo2Thread(String test, Long threadId) {
        int count = 1;
        if (testName2Counter.containsKey(test)) {
            count = testName2Counter.get(test) + 1;
            LOGGER.debug((Object)(test + " test was already registered. Incrementing invocation count to " + count));
        }
        testName2Counter.put(test, count);
        if (count > 1 && RetryCounter.getRunCount() == 0) {
            test = test + String.format(" (InvCount=%s)", String.format("%04d", count));
        }
        Stack<String> stack = new Stack<String>();
        if (threadId2TestName.containsKey(threadId)) {
            stack = threadId2TestName.get(threadId);
        }
        stack.push(test);
        threadId2TestName.put(threadId, stack);
        return test;
    }

    public static synchronized void releaseTestInfoByThread() {
        long threadId = Thread.currentThread().getId();
        if (!TestNamingUtil.isTestNameRegistered()) {
            return;
        }
        Stack<String> stack = threadId2TestName.get(threadId);
        String test = stack.pop();
        LOGGER.debug((Object)("Releasing information about test: " + test));
        if (stack.isEmpty()) {
            threadId2TestName.remove(threadId);
        }
    }

    public static boolean isTestNameRegistered() {
        Stack<String> stack;
        long threadId = Thread.currentThread().getId();
        if (threadId2TestName.get(threadId) != null && (stack = threadId2TestName.get(threadId)).size() > 0) {
            String test = (String)stack.get(stack.size() - 1);
            return test != null;
        }
        return false;
    }

    public static String getTestNameByThread() {
        long threadId = Thread.currentThread().getId();
        Stack<String> stack = threadId2TestName.get(threadId);
        if (stack == null) {
            LOGGER.debug((Object)("Unable to find registered test name for threadId: " + threadId + ". stack is null!"));
            return null;
        }
        if (stack.size() == 0) {
            LOGGER.debug((Object)("Unable to find registered test name for threadId from empty stack: " + threadId));
            return null;
        }
        return (String)stack.get(stack.size() - 1);
    }

    public static synchronized void associateBug(String testName, String id) {
        testName2Bug.put(testName, id);
    }

    public static synchronized String getBug(String testName) {
        if (testName == null) {
            return null;
        }
        return testName2Bug.get(testName);
    }

    public static String getCanonicalTestName(ITestResult result) {
        String testHash;
        if (TestNamingUtil.isTestNameRegistered()) {
            return TestNamingUtil.getTestNameByThread();
        }
        String testName = "";
        Map testnameMap = (Map)result.getTestContext().getAttribute("testNameArgsMap");
        if (testnameMap != null && testnameMap.containsKey(testHash = String.valueOf(Arrays.hashCode(result.getParameters())))) {
            testName = (String)testnameMap.get(testHash);
        }
        if (testName.isEmpty()) {
            testName = result.getTestContext().getCurrentXmlTest().getName();
        }
        if (result.getTestContext().getCurrentXmlTest().getTestParameters().containsKey("{excel_ds_custom_provider}") || result.getTestContext().getCurrentXmlTest().getTestParameters().containsKey("{ds_custom_provider}")) {
            String methodUID = "";
            for (int i = 0; i < result.getParameters().length; ++i) {
                if (result.getParameters()[i] == null || !result.getParameters()[i].toString().contains("TUID:")) continue;
                methodUID = result.getParameters()[i].toString().replace("TUID:", "");
                break;
            }
            if (!methodUID.isEmpty()) {
                testName = methodUID + " - " + testName;
            }
        }
        return StringEscapeUtils.escapeHtml4((String)TestNamingUtil.appendTestMethodName(testName, result.getMethod()));
    }

    public static String getCanonicalTestMethodName(ITestResult result) {
        String testHash;
        String testMethodName = result.getMethod().getMethodName();
        Map testMethodNameMap = (Map)result.getTestContext().getAttribute("testMethodNameArgsMap");
        if (testMethodNameMap != null && testMethodNameMap.containsKey(testHash = String.valueOf(Arrays.hashCode(result.getParameters())))) {
            LOGGER.error((Object)"Error message to check how often this feature is used.");
            testMethodName = (String)testMethodNameMap.get(testHash);
        }
        return StringEscapeUtils.escapeHtml4((String)testMethodName);
    }

    public static String getPackageName(ITestResult result) {
        return StringEscapeUtils.escapeHtml4((String)result.getMethod().getRealClass().getPackage().getName());
    }

    public static String appendTestMethodName(String testName, ITestNGMethod m) {
        int invocationID = -1;
        if (m.getInvocationCount() > 1) {
            invocationID = m.getCurrentInvocationCount() + 1;
        }
        testName = invocationID != -1 ? testName + " - " + TestNamingUtil.adjustTestName(m) + String.format(" (InvCount=%s)", String.format("%04d", invocationID)) : testName + " - " + TestNamingUtil.adjustTestName(m);
        return StringEscapeUtils.escapeHtml4((String)testName);
    }

    private static String adjustTestName(ITestNGMethod m) {
        String testName = Configuration.get(Configuration.Parameter.TEST_NAMING_PATTERN);
        testName = testName.replace("{method_name}", m.getMethodName());
        testName = testName.replace("{method_priority}", String.valueOf(m.getPriority()));
        testName = testName.replace("{method_thread_pool_size}", String.valueOf(m.getThreadPoolSize()));
        testName = m.getDescription() != null ? testName.replace("{method_description}", m.getDescription()) : testName.replace("{method_description}", "");
        return testName;
    }
}

