/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.resources;

import com.qaprosoft.carina.core.foundation.utils.Configuration;
import com.qaprosoft.carina.core.foundation.utils.resources.LocaleReader;
import com.qaprosoft.carina.core.foundation.utils.resources.ResourceURLFilter;
import com.qaprosoft.carina.core.foundation.utils.resources.Resources;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class I18N {
    private static final Logger LOGGER = Logger.getLogger(I18N.class);
    private static ArrayList<ResourceBundle> resBoundles = new ArrayList();

    public static void init() {
        if (!Configuration.getBoolean(Configuration.Parameter.ENABLE_I18N)) {
            return;
        }
        ArrayList<String> loadedResources = new ArrayList<String>();
        List<Locale> locales = LocaleReader.init(Configuration.get(Configuration.Parameter.LANGUAGE));
        for (URL u : Resources.getResourceURLs(new ResourceURLFilter(){

            @Override
            public boolean accept(URL u) {
                String s = u.getPath();
                boolean contains = s.contains("I18N");
                if (contains) {
                    LOGGER.debug((Object)("I18N: file URL: " + u));
                }
                return contains;
            }
        })) {
            LOGGER.debug((Object)String.format("Analyzing '%s' I18N resource for loading...", u));
            String fileName = FilenameUtils.getBaseName((String)u.getPath());
            if (u.getPath().endsWith("I18N.class") || u.getPath().endsWith("I18N$1.class")) continue;
            if (fileName.lastIndexOf(95) == fileName.length() - 3 || fileName.lastIndexOf(95) == fileName.length() - 5) {
                LOGGER.debug((Object)String.format("'%s' resource IGNORED as it looks like localized resource!", fileName));
                continue;
            }
            String filePath = FilenameUtils.getPath((String)u.getPath());
            String resource = filePath.substring(filePath.indexOf("I18N")).replaceAll("/", ".") + fileName;
            if (!loadedResources.contains(resource)) {
                loadedResources.add(resource);
                try {
                    LOGGER.debug((Object)String.format("Adding '%s' resource...", resource));
                    for (Locale locale : locales) {
                        resBoundles.add(ResourceBundle.getBundle(resource, locale));
                    }
                    LOGGER.debug((Object)String.format("Resource '%s' added.", resource));
                }
                catch (MissingResourceException e) {
                    LOGGER.debug((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            LOGGER.debug((Object)String.format("Requested resource '%s' is already loaded into the ResourceBundle!", resource));
        }
        LOGGER.debug((Object)("init: I18N bundle size: " + resBoundles.size()));
    }

    private static Locale getDefaultLanguage() {
        List<Locale> locales = LocaleReader.init(Configuration.get(Configuration.Parameter.LANGUAGE));
        if (locales.size() == 0) {
            throw new RuntimeException("Undefined default language specified! Review 'language' setting in _config.properties.");
        }
        return locales.get(0);
    }

    public static String getText(String key) {
        return I18N.getText(key, I18N.getDefaultLanguage());
    }

    public static String getText(String key, Locale locale) {
        LOGGER.debug((Object)("getText: I18N bundle size: " + resBoundles.size()));
        for (ResourceBundle bundle : resBoundles) {
            try {
                String value = bundle.getString(key);
                LOGGER.debug((Object)("Looking for value for language:'" + locale.getLanguage() + "' current iteration language is: '" + bundle.getLocale().getLanguage() + "'."));
                if (!bundle.getLocale().getLanguage().equals(locale.getLanguage())) continue;
                LOGGER.debug((Object)("Found language:'" + locale.getLanguage() + "' and value is '" + value + "'."));
                return value;
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return key;
    }
}

