/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.tag;

import com.qaprosoft.carina.core.foundation.utils.tag.TestTag;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.testng.ITestResult;

public class TagManager {
    private static final Logger LOGGER = Logger.getLogger(TagManager.class);
    private static final ThreadLocal<HashMap<String, String>> testTags = ThreadLocal.withInitial(HashMap::new);
    private static final String FORBIDDEN_TAG_NAMES = "priority";

    private TagManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getTags(ITestResult result) {
        Map tags = testTags.get();
        try {
            Class<?> testClass = Class.forName(result.getMethod().getTestClass().getName());
            String methodName = result.getMethod().getMethodName();
            Method[] possibleMethods = testClass.getMethods();
            Map declarativeTags = Arrays.stream(possibleMethods).filter(possibleMethod -> possibleMethod.getName().equals(methodName)).findFirst().map(TagManager.retrieveTags()).orElse(new HashMap());
            declarativeTags.forEach(tags::putIfAbsent);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            testTags.remove();
        }
        return tags;
    }

    public static void add(HashMap<String, String> tags) {
        testTags.get().putAll(tags);
    }

    public static void add(String name, String value) {
        testTags.get().put(name, value);
    }

    private static Function<Method, Map<String, String>> retrieveTags() {
        return testMethod -> {
            Annotation methodAnnotation;
            HashMap<String, String> tags = new HashMap<String, String>();
            if (testMethod.isAnnotationPresent(TestTag.class) && TagManager.isValid((methodAnnotation = testMethod.getAnnotation(TestTag.class)).name())) {
                tags.put(methodAnnotation.name(), methodAnnotation.value());
                LOGGER.debug((Object)("Method '" + testMethod + "' tag pair: " + methodAnnotation.name() + " : " + methodAnnotation.value()));
            }
            if (testMethod.isAnnotationPresent(TestTag.List.class)) {
                methodAnnotation = testMethod.getAnnotation(TestTag.List.class);
                for (TestTag tagLocal : methodAnnotation.value()) {
                    if (!TagManager.isValid(tagLocal.name())) continue;
                    tags.put(tagLocal.name(), tagLocal.value());
                    LOGGER.debug((Object)("Method '" + testMethod + "' tag pair: " + tagLocal.name() + " : " + tagLocal.value()));
                }
            }
            return tags;
        };
    }

    private static boolean isValid(String content) {
        Matcher matcher;
        Pattern pattern = Pattern.compile(FORBIDDEN_TAG_NAMES);
        if (content != null && (matcher = pattern.matcher(content)).find()) {
            LOGGER.error((Object)("TestTag name contains one of the forbidden tag names: " + content));
            return false;
        }
        return true;
    }
}

