/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.db.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.qaprosoft.carina.core.foundation.utils.R;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MongoConnector {
    private static Map<String, MongoClient> clients = new HashMap<String, MongoClient>();
    private static String host = R.DATABASE.get("mongo.host");
    private static String port = R.DATABASE.get("mongo.port");
    private static String user = R.DATABASE.get("mongo.user");
    private static String password = R.DATABASE.get("mongo.password");
    private static String database = R.DATABASE.get("mongo.database");

    public static MongoClient createClient() throws NumberFormatException, UnknownHostException {
        if (!clients.containsKey(database)) {
            MongoConnector.validateConfig(database);
            MongoCredential credential = MongoCredential.createMongoCRCredential((String)user, (String)database, (char[])password.toCharArray());
            clients.put(database, new MongoClient(new ServerAddress(host, Integer.valueOf(port).intValue()), Arrays.asList(credential)));
        }
        return clients.get(database);
    }

    public static MongoClient createClient(String database) throws NumberFormatException, UnknownHostException {
        if (!clients.containsKey(database)) {
            MongoConnector.validateConfig(database);
            MongoCredential credential = MongoCredential.createMongoCRCredential((String)user, (String)database, (char[])password.toCharArray());
            clients.put(database, new MongoClient(new ServerAddress(host, Integer.valueOf(port).intValue()), Arrays.asList(credential)));
        }
        return clients.get(database);
    }

    private static void validateConfig(String database) {
        if (StringUtils.isEmpty((CharSequence)host) || "{must_override}".equals(host) || StringUtils.isEmpty((CharSequence)port) || "{must_override}".equals(port) || StringUtils.isEmpty((CharSequence)user) || "{must_override}".equals(user) || StringUtils.isEmpty((CharSequence)password) || "{must_override}".equals(password) || StringUtils.isEmpty((CharSequence)database) || "{must_override}".equals(database)) {
            throw new RuntimeException("Invalid MongoDB config!");
        }
    }

    public static String getHost() {
        return host;
    }

    public static void setHost(String host) {
        MongoConnector.host = host;
    }

    public static String getPort() {
        return port;
    }

    public static void setPort(String port) {
        MongoConnector.port = port;
    }

    public static String getUser() {
        return user;
    }

    public static void setUser(String user) {
        MongoConnector.user = user;
    }

    public static String getPassword() {
        return password;
    }

    public static void setPassword(String password) {
        MongoConnector.password = password;
    }

    public static String getDatabase() {
        return database;
    }

    public static void setDatabase(String database) {
        MongoConnector.database = database;
    }
}

