/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.jira;

import com.qaprosoft.carina.core.foundation.crypto.CryptoTool;
import com.qaprosoft.carina.core.foundation.jira.Bug;
import com.qaprosoft.carina.core.foundation.jira.IJiraUpdater;
import com.qaprosoft.carina.core.foundation.report.TestResultItem;
import com.qaprosoft.carina.core.foundation.utils.Configuration;
import com.qaprosoft.carina.core.foundation.utils.naming.TestNamingUtil;
import com.qaprosoft.zafira.models.db.workitem.BaseWorkItem;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.rcarz.jiraclient.BasicCredentials;
import net.rcarz.jiraclient.ICredentials;
import net.rcarz.jiraclient.Issue;
import net.rcarz.jiraclient.JiraClient;
import org.apache.log4j.Logger;
import org.testng.ITestContext;
import org.testng.ITestResult;

public class Jira {
    private static final int MAX_LENGTH = 45;
    private static final Logger LOG = Logger.getLogger(Jira.class);
    private static IJiraUpdater updater;
    private static JiraClient jira;
    private static boolean isInitialized;
    private static CryptoTool cryptoTool;
    private static Pattern CRYPTO_PATTERN;
    protected static ThreadLocal<List<String>> jiraTickets;
    protected static ThreadLocal<BaseWorkItem> knownIssue;

    public static synchronized void updateAfterTest(ITestResult result) {
        if (isInitialized) {
            try {
                updater.updateAfterTest(jira, result);
            }
            catch (Exception e) {
                LOG.error((Object)("Jira 'updateAfterTest' not performed: " + e.getMessage()));
            }
        }
    }

    public static synchronized void updateAfterSuite(ITestContext context, List<TestResultItem> results) {
        if (isInitialized) {
            try {
                updater.updateAfterSuite(jira, context, results);
            }
            catch (Exception e) {
                LOG.error((Object)("Jira 'updateAfterSuite' not performed: " + e.getMessage()));
            }
        }
    }

    private static void clearTickets() {
        jiraTickets.remove();
    }

    public static void setTickets(List<String> tickets) {
        ArrayList<String> tempTickets = new ArrayList<String>();
        for (String ticket : tickets) {
            tempTickets.add(Jira.parseTicket(ticket));
        }
        jiraTickets.set(tempTickets);
    }

    public static void setTickets(String ... tickets) {
        ArrayList<String> tempTickets = new ArrayList<String>();
        for (String ticket : tickets) {
            tempTickets.add(Jira.parseTicket(ticket));
        }
        Jira.setTickets(tempTickets);
    }

    public static synchronized List<String> getTickets(ITestResult result) {
        String testHash;
        Map testnameJiraMap;
        if (jiraTickets.get() != null) {
            return jiraTickets.get();
        }
        ArrayList<String> tickets = new ArrayList<String>();
        if (result.getTestContext().getCurrentXmlTest().getParameter("JIRA#") != null) {
            tickets.add(Jira.parseTicket(result.getTestContext().getCurrentXmlTest().getParameter("JIRA#")));
        }
        if (result.getMethod().getDescription() != null && result.getMethod().getDescription().contains("JIRA#")) {
            tickets.clear();
            String description = result.getMethod().getDescription();
            if (description.split("#").length > 1) {
                try {
                    tickets.add(Jira.parseTicket(description.split("#")[1].trim()));
                }
                catch (Exception e) {
                    LOG.error((Object)("Incorrect Jira-ticket format: " + description), (Throwable)e);
                }
            }
        }
        if ((testnameJiraMap = (Map)result.getTestContext().getAttribute("jiraArgsMap")) != null && testnameJiraMap.containsKey(testHash = String.valueOf(Arrays.hashCode(result.getParameters())))) {
            tickets.clear();
            tickets.add((String)testnameJiraMap.get(testHash));
        }
        return tickets;
    }

    public static boolean isRetryDisabled(ITestResult result) {
        boolean ignoreKnownIssue = Configuration.getBoolean(Configuration.Parameter.TRACK_KNOWN_ISSUES);
        int knownIssuesCount = Jira.getTickets(result).size();
        boolean disableRetryForKnownIssues = ignoreKnownIssue && knownIssuesCount > 0;
        return disableRetryForKnownIssues;
    }

    public static synchronized String processBug(ITestResult result) {
        if (isInitialized) {
            String testHash;
            Map testnameBugMap;
            Method m;
            Class clazz = result.getMethod().getRealClass();
            try {
                m = clazz.getMethod(result.getMethod().getMethodName(), result.getMethod().getConstructorOrMethod().getMethod().getParameterTypes());
            }
            catch (Exception e) {
                LOG.error((Object)"Exception during test name getting", (Throwable)e);
                return null;
            }
            String test = TestNamingUtil.getTestNameByThread();
            String bugId = TestNamingUtil.getBug(test);
            if (bugId == null && (testnameBugMap = (Map)result.getTestContext().getAttribute("bugArgsMap")) != null && testnameBugMap.containsKey(testHash = String.valueOf(Arrays.hashCode(result.getParameters())))) {
                bugId = (String)testnameBugMap.get(testHash);
            }
            if (bugId == null && m.isAnnotationPresent(Bug.class)) {
                Bug annotation = m.getAnnotation(Bug.class);
                bugId = annotation.id();
            }
            if (bugId != null && !Configuration.get(Configuration.Parameter.JIRA_URL).isEmpty()) {
                String bugUrl = Configuration.get(Configuration.Parameter.JIRA_URL) + "/browse/" + bugId;
                LOG.info((Object)("Bug URL retrieved: " + bugUrl));
                try {
                    Issue bug = jira.getIssue(bugId);
                    return String.format("Bug %s \"%s\" with status \"%s\" associated", bugUrl, bug.getSummary(), bug.getStatus().getName());
                }
                catch (Exception e) {
                    LOG.error((Object)("Exception during retrieving bug info: " + e.getMessage()));
                    LOG.debug((Object)"Exception during retrieving bug info.", (Throwable)e);
                    return null;
                }
            }
        }
        return null;
    }

    public static synchronized void setKnownIssue(String jiraId) {
        Jira.setKnownIssue(jiraId, null);
    }

    public static synchronized void setKnownIssue(String jiraId, String description) {
        Jira.setKnownIssue(jiraId, description, false);
    }

    public static synchronized void setKnownIssue(String jiraId, String description, boolean blocker) {
        BaseWorkItem workItem = new BaseWorkItem(jiraId, description, blocker);
        knownIssue.set(workItem);
    }

    public static BaseWorkItem getKnownIssue() {
        return knownIssue.get();
    }

    private static void clearKnownIssue() {
        knownIssue.remove();
    }

    public static void clearJiraArtifacts() {
        Jira.clearTickets();
        Jira.clearKnownIssue();
    }

    private static String parseTicket(String ticket) {
        if (ticket.contains(",")) {
            ticket = ticket.split(",")[0];
        }
        if (ticket.contains(" ")) {
            ticket = ticket.split(" ")[0];
        }
        if (ticket.length() > 45) {
            LOG.error((Object)("Too big jira ticket will be cut (45 chars max!) Ticket: '" + ticket + "';"));
            ticket = ticket.substring(0, 45);
        }
        return ticket;
    }

    static {
        isInitialized = false;
        CRYPTO_PATTERN = Pattern.compile("\\{crypt:[^\\{\\}]*\\}");
        jiraTickets = new ThreadLocal();
        knownIssue = new ThreadLocal();
        try {
            cryptoTool = new CryptoTool(Configuration.get(Configuration.Parameter.CRYPTO_KEY_PATH));
            updater = (IJiraUpdater)Class.forName(Configuration.get(Configuration.Parameter.JIRA_UPDATER)).newInstance();
            BasicCredentials creds = new BasicCredentials(cryptoTool.decryptByPattern(Configuration.get(Configuration.Parameter.JIRA_USER), CRYPTO_PATTERN), cryptoTool.decryptByPattern(Configuration.get(Configuration.Parameter.JIRA_PASSWORD), CRYPTO_PATTERN));
            jira = new JiraClient(Configuration.get(Configuration.Parameter.JIRA_URL), (ICredentials)creds);
            isInitialized = true;
        }
        catch (Exception e) {
            LOG.info((Object)("Jira update utility not initialized (specify jira_updater, jira_url, jira_user, jira_password, crypto_key_path): " + e.getMessage()));
        }
    }
}

