/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.log;

import com.qaprosoft.carina.core.foundation.report.ReportContext;
import com.qaprosoft.carina.core.foundation.utils.Configuration;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.MDC;
import org.apache.log4j.spi.LoggingEvent;

public class ThreadLogAppender
extends AppenderSkeleton {
    private final ThreadLocal<BufferedWriter> testLogBuffer = new ThreadLocal();
    private long bytesWritten;

    public void append(LoggingEvent event) {
        try {
            BufferedWriter fw = this.testLogBuffer.get();
            if (fw == null) {
                File testLogFile = new File(ReportContext.getTestDir() + "/test.log");
                if (!testLogFile.exists()) {
                    testLogFile.createNewFile();
                    this.bytesWritten = 0L;
                }
                fw = new BufferedWriter(new FileWriter(testLogFile, true));
                this.testLogBuffer.set(fw);
            }
            if (event != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                String time = dateFormat.format(event.getTimeStamp());
                long threadId = Thread.currentThread().getId();
                MDC.put((String)"threadId", (Object)("-" + String.valueOf(threadId)));
                String fileName = event.getLocationInformation().getFileName();
                String logLevel = event.getLevel().toString();
                String message = "[%s] [%s] [%s] [%s] %s";
                message = String.format(message, time, fileName, threadId, logLevel, event.getMessage().toString());
                this.ensureCapacity(message.length());
                fw.write(message);
            } else {
                fw.write("null");
            }
            fw.write("\n");
            fw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            BufferedWriter fw = this.testLogBuffer.get();
            if (fw != null) {
                fw.close();
                this.testLogBuffer.remove();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    private void ensureCapacity(int len) throws IOException {
        long newBytesWritten = this.bytesWritten + (long)len;
        long maxMegaBytes = Configuration.getLong(Configuration.Parameter.MAX_LOG_FILE_SIZE) * 1024L * 1024L;
        if (newBytesWritten > maxMegaBytes) {
            throw new IOException("test Log file size exceeded core limit: " + newBytesWritten + " > " + maxMegaBytes);
        }
        this.bytesWritten = newBytesWritten;
    }
}

