/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.performance;

import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class Timer {
    private static final Logger LOGGER = Logger.getLogger(Timer.class);
    private static ThreadLocal<ConcurrentHashMap<String, Long>> metrics = new ThreadLocal();
    private static ThreadLocal<ConcurrentHashMap<String, Long>> timer = new ThreadLocal();

    public static synchronized void start(IPerformanceOperation operation) {
        Timer.start(operation, "");
    }

    public static synchronized void start(IPerformanceOperation operation, String key) {
        String operationKey = operation.getKey() + key;
        Map<String, Long> testTimer = Timer.getTimer();
        if (testTimer.containsKey(operationKey)) {
            LOGGER.error((Object)("Operation already started: " + operationKey));
        } else {
            testTimer.put(operationKey, Calendar.getInstance().getTimeInMillis());
        }
    }

    public static synchronized long stop(IPerformanceOperation operation) {
        return Timer.stop(operation, "");
    }

    public static synchronized long stop(IPerformanceOperation operation, String key) {
        String operationKey = operation.getKey() + key;
        Map<String, Long> testTimer = Timer.getTimer();
        if (!testTimer.containsKey(operationKey)) {
            LOGGER.error((Object)("Operation not started: " + operationKey));
            testTimer.remove(operationKey);
            return 0L;
        }
        Map<String, Long> testMertrics = Timer.getMetrics();
        long capturedTime = 0L;
        if (testMertrics.get(operationKey) != null) {
            capturedTime = testMertrics.get(operationKey);
        }
        long elapsedTime = testTimer.get(operationKey);
        testMertrics.put(operationKey, capturedTime + Calendar.getInstance().getTimeInMillis() - elapsedTime);
        testTimer.remove(operationKey);
        return elapsedTime;
    }

    public static synchronized Map<String, Long> readAndClear() {
        Map<String, Long> testTimer = Timer.getTimer();
        for (String key : testTimer.keySet()) {
            LOGGER.debug((Object)("Timer not stopped for operation: " + key));
        }
        Map<String, Long> testMertrics = Timer.getMetrics();
        ConcurrentHashMap<String, Long> returnMetrics = new ConcurrentHashMap<String, Long>(testMertrics);
        testTimer.clear();
        testMertrics.clear();
        return returnMetrics;
    }

    private static Map<String, Long> getTimer() {
        ConcurrentHashMap<String, Long> testTimer = timer.get();
        if (testTimer == null) {
            testTimer = new ConcurrentHashMap();
            timer.set(testTimer);
        }
        return testTimer;
    }

    public static synchronized void clear() {
        Timer.getMetrics().clear();
    }

    private static Map<String, Long> getMetrics() {
        ConcurrentHashMap<String, Long> testMetrics = metrics.get();
        if (testMetrics == null) {
            testMetrics = new ConcurrentHashMap();
            metrics.set(testMetrics);
        }
        return testMetrics;
    }

    public static interface IPerformanceOperation {
        public String getKey();
    }
}

