/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.retry;

import com.qaprosoft.carina.core.foundation.jira.Jira;
import com.qaprosoft.carina.core.foundation.utils.Configuration;
import org.apache.log4j.Logger;
import org.testng.IRetryAnalyzer;
import org.testng.ITestResult;

public class RetryAnalyzer
implements IRetryAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(RetryAnalyzer.class);
    private static ThreadLocal<Integer> runCount = new ThreadLocal();

    public boolean retry(ITestResult result) {
        this.incrementRunCount();
        if (result.getThrowable() != null && result.getThrowable().getMessage() != null && result.getThrowable().getMessage().startsWith("ALREADY_PASSED")) {
            LOGGER.debug((Object)("AlreadyPassedRetryAnalyzer: " + result.getMethod().getRetryAnalyzer(result) + "Method: " + result.getMethod().getMethodName() + "; Incremented retryCount: " + this.getRunCount()));
            return false;
        }
        LOGGER.debug((Object)("RetryAnalyzer: " + result.getMethod().getRetryAnalyzer(result) + "Method: " + result.getMethod().getMethodName() + "; Incremented retryCount: " + this.getRunCount()));
        return this.getRunCount() <= RetryAnalyzer.getMaxRetryCountForTest() && !Jira.isRetryDisabled(result);
    }

    public Integer getRunCount() {
        int count = 0;
        if (runCount.get() != null) {
            count = runCount.get();
        }
        return count;
    }

    public void incrementRunCount() {
        int count = 0;
        if (runCount.get() != null) {
            count = runCount.get();
        }
        runCount.set(++count);
    }

    public void resetCounter() {
        runCount.set(0);
    }

    public static int getMaxRetryCountForTest() {
        return Configuration.getInt(Configuration.Parameter.RETRY_COUNT);
    }
}

