/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class FileManager {
    private static final Logger LOGGER = Logger.getLogger(FileManager.class);

    public static void removeDirRecurs(String directory) {
        File dir = new File(directory);
        if (dir.exists() && dir.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)dir);
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage());
            }
        }
    }

    public static synchronized List<File> getFilesInDir(File directory) {
        ArrayList<File> files = new ArrayList<File>();
        try {
            File[] fileArray = directory.listFiles();
            if (fileArray == null) {
                return files;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                files.add(fileArray[i]);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to get files in dir!", (Throwable)e);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFileWithContent(String filePath, String content) {
        File file = new File(filePath);
        try {
            file.createNewFile();
            FileWriter fw = new FileWriter(file);
            try {
                fw.write(content);
            }
            catch (Exception e) {
                LOGGER.debug((Object)("Error during FileWriter append. " + e.getMessage()), e.getCause());
            }
            finally {
                try {
                    fw.close();
                }
                catch (Exception e) {
                    LOGGER.debug((Object)("Error during FileWriter close. " + e.getMessage()), e.getCause());
                }
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)e.getMessage(), e.getCause());
        }
    }

    public static void zipFiles(String output, File ... files) {
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(output));){
            for (File fileToZip : files) {
                zipOut.putNextEntry(new ZipEntry(fileToZip.getName()));
                Files.copy(fileToZip.toPath(), zipOut);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"Unable to find file for archive operation!", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"IO exception for archive operation!", (Throwable)e);
        }
    }
}

