/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils;

import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.io.RandomAccessBufferedFileInputStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

public class PDFUtil {
    public static String readTxtFromPDF(InputStream inputStream, int startPage, int endPage) {
        PDFTextStripper pdfStripper = null;
        PDDocument pdDoc = null;
        COSDocument cosDoc = null;
        RandomAccessBufferedFileInputStream randomAccessBufferedFileInputStream = null;
        if (inputStream == null) {
            throw new RuntimeException("Input stream not opened");
        }
        try {
            randomAccessBufferedFileInputStream = new RandomAccessBufferedFileInputStream(inputStream);
            PDFParser parser = new PDFParser((RandomAccessRead)randomAccessBufferedFileInputStream);
            parser.parse();
            cosDoc = parser.getDocument();
            pdfStripper = new PDFTextStripper();
            pdDoc = new PDDocument(cosDoc);
            pdfStripper.setSortByPosition(true);
            pdfStripper.setStartPage(startPage);
            pdfStripper.setEndPage(endPage);
            String string = pdfStripper.getText(pdDoc);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (cosDoc != null) {
                    cosDoc.close();
                }
                if (pdDoc != null) {
                    pdDoc.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (randomAccessBufferedFileInputStream != null) {
                    randomAccessBufferedFileInputStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

