/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils;

import com.qaprosoft.carina.core.foundation.exception.PlaceholderResolverException;
import com.qaprosoft.carina.core.foundation.utils.Configuration;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class PlaceholderResolver {
    private static final Logger LOGGER = Logger.getLogger(PlaceholderResolver.class);
    private static final Pattern PATTERN = Pattern.compile("\\$\\{[^\\{\\}]*\\}");

    public static String resolve(Properties properties, String key) {
        String value = properties.getProperty(key);
        if (value != null) {
            Matcher matcher = PATTERN.matcher(value);
            while (matcher.find()) {
                String placeholder = matcher.group();
                String placeholderKey = placeholder.replace("${", "").replace("}", "");
                String resolvedValue = PlaceholderResolver.resolve(properties, placeholderKey);
                if (resolvedValue == null) continue;
                value = value.replace(placeholder, resolvedValue);
            }
        } else if (!key.startsWith("capabilities") && !key.endsWith(Configuration.Parameter.URL.getKey())) {
            LOGGER.warn((Object)("Value not resolved by key: " + key));
        }
        return value;
    }

    public static boolean isValid(Properties properties) {
        Set<Object> keys = properties.keySet();
        for (Object key : keys) {
            try {
                PlaceholderResolver.resolve(properties, (String)key);
            }
            catch (StackOverflowError e) {
                LOGGER.error((Object)("Infinit placeholder loop was found for '" + properties.getProperty((String)key) + "'"));
                return false;
            }
            catch (PlaceholderResolverException e) {
                LOGGER.error((Object)e.getMessage());
                return false;
            }
        }
        return true;
    }
}

