/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils;

import com.qaprosoft.carina.core.foundation.exception.InvalidConfigurationException;
import com.qaprosoft.carina.core.foundation.utils.PlaceholderResolver;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public enum R {
    API("api.properties"),
    CONFIG("config.properties"),
    TESTDATA("testdata.properties"),
    EMAIL("email.properties"),
    REPORT("report.properties"),
    DATABASE("database.properties"),
    ZAFIRA("zafira.properties");

    private static final Logger LOGGER;
    private static final String OVERRIDE_SIGN = "_";
    private String resourceFile;
    private static ThreadLocal<Properties> testProperties;
    private static Map<String, Properties> propertiesHolder;

    private R(String resourceKey) {
        this.resourceFile = resourceKey;
    }

    public void put(String key, String value) {
        this.put(key, value, false);
    }

    public void put(String key, String value, boolean currentTestOnly) {
        if (currentTestOnly) {
            LOGGER.warn((Object)("Override property for current test '" + key + "=" + value + "'!"));
            this.getTestProperties().put(key, value);
        } else {
            propertiesHolder.get(this.resourceFile).put(key, value);
        }
    }

    public boolean containsKey(String key) {
        return propertiesHolder.get(this.resourceFile).containsKey(key) || this.getTestProperties().containsKey(key);
    }

    public String get(String key) {
        String value = this.getTestProperties().getProperty(key);
        if (value != null) {
            LOGGER.warn((Object)("Overriden '" + key + "=" + value + "' property will be used for current test!"));
            return value;
        }
        value = R.CONFIG.resourceFile.equals(this.resourceFile) ? PlaceholderResolver.resolve(propertiesHolder.get(this.resourceFile), key) : propertiesHolder.get(this.resourceFile).getProperty(key);
        return value != null ? value : "";
    }

    public int getInt(String key) {
        return Integer.parseInt(this.get(key));
    }

    public long getLong(String key) {
        return Long.parseLong(this.get(key));
    }

    public double getDouble(String key) {
        return Double.parseDouble(this.get(key));
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.get(key));
    }

    public static String getResourcePath(String resource) {
        String path = StringUtils.removeStart((String)ClassLoader.getSystemResource(resource).getPath(), (String)"/");
        path = StringUtils.replaceChars((String)path, (String)"/", (String)"\\");
        path = StringUtils.replaceChars((String)path, (String)"!", (String)"");
        return path;
    }

    public Properties getProperties() {
        Properties globalProp = propertiesHolder.get(this.resourceFile);
        if (!testProperties.get().isEmpty()) {
            Properties testProp = testProperties.get();
            LOGGER.debug((Object)String.format("CurrentTestOnly properties has [%s] entries.", testProp.size()));
            LOGGER.debug((Object)testProp.toString());
            HashMap<Object, Object> testCapabilitiesMap = new HashMap<Object, Object>(testProp);
            testCapabilitiesMap.keySet().stream().forEach(i -> {
                if (globalProp.containsKey(i)) {
                    LOGGER.debug((Object)String.format("Global properties already contains key --- %s --- with value --- %s ---. Global property will be overridden by  --- %s --- from test properties.", i, globalProp.get(i), testProp.get(i)));
                } else {
                    LOGGER.debug((Object)String.format("Global properties isn't contains key --- %s ---.  Global key --- %s --- will be set to --- %s ---  from test properties.", i, i, testProp.get(i)));
                }
                globalProp.setProperty((String)i, (String)testProp.get(i));
            });
        }
        return globalProp;
    }

    public void clearTestProperties() {
        LOGGER.debug((Object)"Clear temporary test properties.");
        testProperties.remove();
    }

    public Properties getTestProperties() {
        if (testProperties.get() == null) {
            Properties properties = new Properties();
            testProperties.set(properties);
        }
        return testProperties.get();
    }

    static {
        LOGGER = Logger.getLogger(R.class);
        testProperties = new ThreadLocal();
        propertiesHolder = new HashMap<String, Properties>();
        for (R resource : R.values()) {
            try {
                URL overrideResource;
                Properties properties = new Properties();
                URL baseResource = ClassLoader.getSystemResource(resource.resourceFile);
                if (baseResource != null) {
                    properties.load(baseResource.openStream());
                    LOGGER.debug((Object)("Base properties loaded: " + resource.resourceFile));
                }
                String resourceName = OVERRIDE_SIGN + resource.resourceFile;
                while ((overrideResource = ClassLoader.getSystemResource(resourceName)) != null) {
                    properties.load(overrideResource.openStream());
                    LOGGER.debug((Object)("Override properties loaded: " + resourceName));
                    resourceName = OVERRIDE_SIGN + resourceName;
                }
                for (Object key : properties.keySet()) {
                    String systemValue = System.getProperty((String)key);
                    if (StringUtils.isEmpty((CharSequence)systemValue)) continue;
                    properties.put(key, systemValue);
                }
                if (resource.resourceFile.contains("config.properties")) {
                    String prefix = "capabilities.";
                    HashMap<Object, Object> javaProperties = new HashMap<Object, Object>(System.getProperties());
                    for (Map.Entry entry : javaProperties.entrySet()) {
                        String value;
                        String key = (String)entry.getKey();
                        if (!key.toLowerCase().startsWith("capabilities.") || StringUtils.isEmpty((CharSequence)(value = (String)entry.getValue()))) continue;
                        properties.put(key, value);
                    }
                }
                propertiesHolder.put(resource.resourceFile, properties);
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Invalid config in '" + (Object)((Object)resource) + "': " + e.getMessage());
            }
        }
    }
}

