/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.android.recorder.utils;

import com.qaprosoft.carina.core.foundation.utils.android.recorder.utils.Kernel32;
import com.qaprosoft.carina.core.foundation.utils.android.recorder.utils.W32API;
import com.sun.jna.Pointer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Locale;
import org.apache.log4j.Logger;

public class Platform {
    private static final Logger LOGGER = Logger.getLogger(Platform.class);
    public static final String NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    public static final boolean IS_WINDOWS = NAME.startsWith("windows");
    public static final boolean IS_MAC_OS_X = NAME.startsWith("mac os x");
    public static final boolean IS_LINUX = NAME.startsWith("linux");
    private static final String[] WIN_CMD = new String[0];
    private static final String[] MAC_CMD = new String[0];

    public static String[] getCmd() {
        if (IS_WINDOWS) {
            return WIN_CMD;
        }
        if (IS_MAC_OS_X || IS_LINUX) {
            return MAC_CMD;
        }
        throw new RuntimeException("Unsupported platform detected.");
    }

    public static int getPID(Process process) {
        if (IS_MAC_OS_X || IS_LINUX) {
            return Platform.getUnixProcessPID(process);
        }
        if (IS_WINDOWS) {
            return Platform.getWinPid(process);
        }
        throw new RuntimeException("Can't get PID properly.");
    }

    public static void killProcesses(Collection<Integer> PIDs) {
        if (IS_MAC_OS_X || IS_LINUX) {
            Platform.killUnixProcessesTree(PIDs);
        } else if (IS_WINDOWS) {
            Platform.killWindowsProcessesTree(PIDs);
        } else {
            throw new RuntimeException("Unsupported platform detected.");
        }
    }

    private static void killWindowsProcessesTree(Collection<Integer> PIDs) {
        try {
            StringBuilder sb = new StringBuilder("taskkill");
            for (Integer pid : PIDs) {
                sb.append(" /pid ").append(pid);
            }
            String cmd = sb.append(" /F /T").toString();
            LOGGER.debug((Object)cmd);
            Runtime.getRuntime().exec(cmd);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void killUnixProcessesTree(Collection<Integer> PIDs) {
        try {
            StringBuilder sb = new StringBuilder("kill -9");
            for (Integer pid : PIDs) {
                sb.append(" ").append(pid);
            }
            String cmd = sb.toString();
            LOGGER.debug((Object)cmd);
            Runtime.getRuntime().exec(cmd);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int getUnixProcessPID(Process process) {
        if (process.getClass().getName().equals("java.lang.UNIXProcess")) {
            try {
                Field f = process.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                int pid = f.getInt(process);
                return pid;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    private static int getWinPid(Process process) {
        int pid = -1;
        if (process.getClass().getName().equals("java.lang.Win32Process") || process.getClass().getName().equals("java.lang.ProcessImpl")) {
            try {
                Field f = process.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                long handlePtr = f.getLong(process);
                Kernel32 kernel = Kernel32.INSTANCE;
                W32API.HANDLE handle = new W32API.HANDLE();
                handle.setPointer(Pointer.createConstant((long)handlePtr));
                pid = kernel.GetProcessId(handle);
                return pid;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -1;
    }
}

