/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.ftp;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;

public class FtpUtils {
    private static final Logger LOGGER = Logger.getLogger(FtpUtils.class);
    private static final int DEFAULT_PORT = 21;
    private static int uploading = 0;

    public static void uploadFile(String ftpHost, String user, String password, String filePassToUpload, String fileName) {
        FtpUtils.uploadFile(ftpHost, 21, user, password, filePassToUpload, fileName);
    }

    public static void uploadFile(String ftpHost, int port, String user, String password, String filePassToUpload, String fileName) {
        try (FileInputStream is = new FileInputStream(filePassToUpload);){
            FtpUtils.upload(ftpHost, port, user, password, is, fileName);
        }
        catch (FileNotFoundException e) {
            LOGGER.info((Object)"File is not found. Specify correct file pass");
        }
        catch (IOException e) {
            LOGGER.info((Object)"Exception while opening file for upload.");
        }
    }

    public static void uploadData(String ftpHost, String user, String password, String data, String destinationFileName) {
        FtpUtils.uploadData(ftpHost, 21, user, password, data, destinationFileName);
    }

    public static void uploadData(String ftpHost, int port, String user, String password, String data, String destinationFileName) {
        byte[] decode = Base64.getDecoder().decode(data);
        LOGGER.debug((Object)("Data size to upload: " + data.length()));
        LOGGER.debug((Object)("Encoded data size to upload: " + decode.length));
        try (ByteArrayInputStream is = new ByteArrayInputStream(decode);){
            FtpUtils.upload(ftpHost, port, user, password, is, destinationFileName);
        }
        catch (IOException e) {
            LOGGER.info((Object)"Exception while opening file for upload.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void upload(String ftpHost, int port, String user, String password, InputStream is, String fileName) {
        LOGGER.debug((Object)("FTP host to upload data : " + ftpHost));
        LOGGER.debug((Object)("FTP port to upload data : " + port));
        LOGGER.debug((Object)("Destination file name : " + fileName));
        long start = System.currentTimeMillis();
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(ftpHost, port);
            LOGGER.debug((Object)("Connected to server : " + ftpHost));
            int reply = ftp.getReplyCode();
            LOGGER.debug((Object)("Reply code is : " + reply));
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                LOGGER.error((Object)("FTP server refused connection. Reply code is : " + reply));
                throw new Exception("FTP server refused connection.");
            }
            if (!ftp.login(user, password)) {
                throw new Exception("Login to ftp failed. Check user credentials.");
            }
            LOGGER.debug((Object)"User has been successfully logged in.");
            ftp.setFileType(2);
            try {
                ftp.enterLocalPassiveMode();
                LOGGER.debug((Object)("Passive host : " + ftp.getPassiveHost() + " Passive port : " + ftp.getPassivePort()));
                LOGGER.debug((Object)("Default port : " + ftp.getDefaultPort()));
                LOGGER.debug((Object)("Local port : " + ftp.getLocalPort()));
                LOGGER.debug((Object)("Remote port : " + ftp.getRemotePort()));
                ++uploading;
                LOGGER.info((Object)("Uploading video: " + fileName));
                if (ftp.storeFile(fileName, is)) {
                    LOGGER.info((Object)("Uploaded video in " + (System.currentTimeMillis() - start) + " msecs for: " + fileName));
                } else {
                    LOGGER.error((Object)("Failed to upload video in " + (System.currentTimeMillis() - start) + " msecs for: " + fileName));
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"Exception while storing file to FTP", (Throwable)e);
            }
            finally {
                --uploading;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception while uploading while to FTP", (Throwable)e);
        }
        finally {
            FtpUtils.ftpDisconnect(ftp);
        }
    }

    public static void ftpDisconnect(FTPClient ftp) {
        try {
            if (ftp.isConnected()) {
                try {
                    ftp.logout();
                    ftp.disconnect();
                }
                catch (Exception ioe) {
                    LOGGER.error((Object)"Exception while disconnecting ftp", (Throwable)ioe);
                }
            }
        }
        catch (Throwable thr) {
            LOGGER.error((Object)"Throwable while disconnecting ftp", thr);
        }
        LOGGER.debug((Object)"FTP has been successfully disconnected.");
    }

    public static boolean isUploading() {
        return uploading > 0;
    }
}

