/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.ownership;

import com.qaprosoft.carina.core.foundation.utils.Configuration;
import com.qaprosoft.carina.core.foundation.utils.ownership.MethodOwner;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import org.apache.log4j.Logger;
import org.testng.ITestContext;
import org.testng.ITestResult;

public class Ownership {
    private static final Logger LOGGER = Logger.getLogger(Ownership.class);

    private Ownership() {
    }

    public static String getMethodOwner(ITestResult result) {
        String testHash;
        Map testMethodOwnerArgsMap = (Map)result.getTestContext().getAttribute("testMethodOwnerArgsMap");
        if (testMethodOwnerArgsMap != null && testMethodOwnerArgsMap.containsKey(testHash = String.valueOf(Arrays.hashCode(result.getParameters()))) && testMethodOwnerArgsMap.get(testHash) != null) {
            return (String)testMethodOwnerArgsMap.get(testHash);
        }
        String owner = "";
        try {
            String actualPlatform;
            Annotation methodAnnotation;
            Method[] possibleMethods;
            Class<?> testClass = Class.forName(result.getMethod().getTestClass().getName());
            String methodName = result.getMethod().getMethodName();
            AccessibleObject testMethod = null;
            for (Method possibleMethod : possibleMethods = testClass.getMethods()) {
                if (!possibleMethod.getName().equals(methodName)) continue;
                testMethod = possibleMethod;
                break;
            }
            if (testMethod.isAnnotationPresent(MethodOwner.class)) {
                methodAnnotation = ((Method)testMethod).getAnnotation(MethodOwner.class);
                owner = methodAnnotation.owner();
            }
            if (testMethod != null && testMethod.isAnnotationPresent(MethodOwner.List.class)) {
                methodAnnotation = ((Method)testMethod).getAnnotation(MethodOwner.List.class);
                for (MethodOwner methodOwner : methodAnnotation.value()) {
                    actualPlatform = methodOwner.platform();
                    if (!actualPlatform.isEmpty()) continue;
                    owner = methodOwner.owner();
                    break;
                }
            }
            if (testMethod != null && testMethod.isAnnotationPresent(MethodOwner.List.class)) {
                methodAnnotation = ((Method)testMethod).getAnnotation(MethodOwner.List.class);
                for (MethodOwner methodOwner : methodAnnotation.value()) {
                    actualPlatform = methodOwner.platform();
                    String expectedPlatform = Configuration.getPlatform();
                    if (actualPlatform.isEmpty() || !Ownership.isValidPlatform(actualPlatform, expectedPlatform)) continue;
                    owner = methodOwner.owner();
                }
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return owner;
    }

    private static boolean isValidPlatform(String actualPlatform, String expectedPlatform) {
        return actualPlatform.equalsIgnoreCase(expectedPlatform);
    }

    public static String getSuiteOwner(ITestContext context) {
        String owner = context.getSuite().getParameter("suiteOwner");
        if (owner == null) {
            owner = "";
        }
        return owner;
    }
}

