/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.resources;

import com.qaprosoft.carina.core.foundation.utils.Configuration;
import com.qaprosoft.carina.core.foundation.utils.resources.LocaleReader;
import com.qaprosoft.carina.core.foundation.utils.resources.ResourceURLFilter;
import com.qaprosoft.carina.core.foundation.utils.resources.Resources;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class L10N {
    private static final Logger LOGGER = Logger.getLogger(L10N.class);
    private static ArrayList<ResourceBundle> resBoundles = new ArrayList();

    public static void init() {
        if (!Configuration.getBoolean(Configuration.Parameter.ENABLE_L10N)) {
            return;
        }
        List<Locale> locales = LocaleReader.init(Configuration.get(Configuration.Parameter.LOCALE));
        ArrayList<String> loadedResources = new ArrayList<String>();
        for (URL u : Resources.getResourceURLs(new ResourceURLFilter(){

            @Override
            public boolean accept(URL u) {
                String s = u.getPath();
                boolean contains = s.contains("L10N");
                if (contains) {
                    LOGGER.debug((Object)("L10N: file URL: " + u));
                }
                return contains;
            }
        })) {
            LOGGER.debug((Object)String.format("Analyzing '%s' L10N resource for loading...", u));
            String fileName = FilenameUtils.getBaseName((String)u.getPath());
            if (u.getPath().endsWith("L10N.class") || u.getPath().endsWith("L10N$1.class")) continue;
            if (fileName.lastIndexOf(95) == fileName.length() - 3 || fileName.lastIndexOf(95) == fileName.length() - 5) {
                LOGGER.debug((Object)String.format("'%s' resource IGNORED as it looks like localized resource!", fileName));
                continue;
            }
            String filePath = FilenameUtils.getPath((String)u.getPath());
            int index = filePath.indexOf("L10N");
            if (index == -1) {
                LOGGER.warn((Object)("Unable to find L10N pattern for " + u.getPath() + " resource!"));
                continue;
            }
            String resource = filePath.substring(filePath.indexOf("L10N")).replaceAll("/", ".") + fileName;
            if (!loadedResources.contains(resource)) {
                loadedResources.add(resource);
                try {
                    LOGGER.debug((Object)String.format("Adding '%s' resource...", resource));
                    for (Locale locale : locales) {
                        resBoundles.add(ResourceBundle.getBundle(resource, locale));
                    }
                    LOGGER.debug((Object)String.format("Resource '%s' added.", resource));
                }
                catch (MissingResourceException e) {
                    LOGGER.debug((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            LOGGER.debug((Object)String.format("Requested resource '%s' is already loaded into the ResourceBundle!", resource));
        }
        LOGGER.debug((Object)("init: L10N bundle size: " + resBoundles.size()));
    }

    public static Locale getDefaultLocale() {
        List<Locale> locales = LocaleReader.init(Configuration.get(Configuration.Parameter.LOCALE));
        if (locales.size() == 0) {
            throw new RuntimeException("Undefined default locale specified! Review 'locale' setting in _config.properties.");
        }
        return locales.get(0);
    }

    public static String getText(String key) {
        return L10N.getText(key, L10N.getDefaultLocale());
    }

    public static String getText(String key, Locale locale) {
        LOGGER.debug((Object)("getText: L10N bundle size: " + resBoundles.size()));
        for (ResourceBundle bundle : resBoundles) {
            try {
                String value = bundle.getString(key);
                if (L10N.isUTF8()) {
                    try {
                        LOGGER.debug((Object)("converting key '" + value + "' to UTF-8"));
                        value = new String(value.getBytes("ISO-8859-1"), "UTF-8");
                    }
                    catch (UnsupportedEncodingException er) {
                        LOGGER.debug((Object)"Error: ", (Throwable)er);
                    }
                }
                LOGGER.debug((Object)("Looking for value for locale:'" + locale.toString() + "' current iteration locale is: '" + bundle.getLocale().toString() + "'."));
                if (!bundle.getLocale().toString().equals(locale.toString())) continue;
                LOGGER.debug((Object)("Found locale:'" + locale.toString() + "' and value is '" + value + "'."));
                return value;
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return key;
    }

    public static String formatString(String resource, String ... parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            resource = resource.replace("{" + i + "}", parameters[i]);
            LOGGER.debug((Object)("Localized string value is: " + resource));
        }
        return resource;
    }

    public static String generateConcatForXPath(String xpathString) {
        String returnString = "";
        String searchString = xpathString;
        char[] quoteChars = new char[]{'\'', '\"'};
        int quotePos = StringUtils.indexOfAny((CharSequence)searchString, (char[])quoteChars);
        if (quotePos == -1) {
            returnString = "'" + searchString + "'";
        } else {
            returnString = "concat(";
            LOGGER.debug((Object)("Current concatenation: " + returnString));
            while (quotePos != -1) {
                String subString = searchString.substring(0, quotePos);
                returnString = returnString + "'" + subString + "', ";
                LOGGER.debug((Object)("Current concatenation: " + returnString));
                if (searchString.substring(quotePos, quotePos + 1).equals("'")) {
                    returnString = returnString + "\"'\", ";
                    LOGGER.debug((Object)("Current concatenation: " + returnString));
                } else {
                    returnString = returnString + "'\"', ";
                    LOGGER.debug((Object)("Current concatenation: " + returnString));
                }
                searchString = searchString.substring(quotePos + 1, searchString.length());
                quotePos = StringUtils.indexOfAny((CharSequence)searchString, (char[])quoteChars);
            }
            returnString = returnString + "'" + searchString + "')";
            LOGGER.debug((Object)("Concatenation result: " + returnString));
        }
        return returnString;
    }

    public static boolean isUTF8() {
        String encoding = "ISO-8859-1";
        try {
            encoding = Configuration.get(Configuration.Parameter.L10N_ENCODING);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"There is no l10n_encoding parameter in config properties.");
        }
        LOGGER.debug((Object)("Will use L10N encoding: " + encoding));
        return encoding.toUpperCase().contains("UTF-8");
    }
}

