/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.resources;

import com.qaprosoft.carina.core.foundation.utils.resources.ResourceURLFilter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class Resources {
    private static final Logger LOGGER = Logger.getLogger(Resources.class);

    private static void collectURL(ResourceURLFilter f, Set<URL> s, URL u) {
        if (f == null || f.accept(u)) {
            LOGGER.debug((Object)("adding resource url by filter: " + u));
            s.add(u);
        }
    }

    private static void iterateFileSystem(File r, ResourceURLFilter f, Set<URL> s) {
        File[] files;
        for (File file : files = r.listFiles()) {
            if (file.isDirectory()) {
                Resources.iterateFileSystem(file, f, s);
                continue;
            }
            if (!file.isFile()) continue;
            try {
                Resources.collectURL(f, s, file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void iterateEntry(File p, ResourceURLFilter f, Set<URL> s) {
        if (p.isDirectory()) {
            Resources.iterateFileSystem(p, f, s);
        }
    }

    public static Set<URL> getResourceURLs() {
        return Resources.getResourceURLs((ResourceURLFilter)null);
    }

    public static Set<URL> getResourceURLs(Class rootClass) {
        return Resources.getResourceURLs(rootClass, null);
    }

    public static Set<URL> getResourceURLs(ResourceURLFilter filter) {
        HashSet<URL> collectedURLs = new HashSet<URL>();
        URLClassLoader ucl = (URLClassLoader)ClassLoader.getSystemClassLoader();
        for (URL url : ucl.getURLs()) {
            try {
                Resources.iterateEntry(new File(url.toURI()), filter, collectedURLs);
            }
            catch (URISyntaxException e) {
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return collectedURLs;
    }

    public static Set<URL> getResourceURLs(Class rootClass, ResourceURLFilter filter) {
        HashSet<URL> collectedURLs = new HashSet<URL>();
        CodeSource src = rootClass.getProtectionDomain().getCodeSource();
        try {
            Resources.iterateEntry(new File(src.getLocation().toURI()), filter, collectedURLs);
        }
        catch (URISyntaxException e) {
            LOGGER.debug((Object)e.getMessage(), (Throwable)e);
        }
        return collectedURLs;
    }
}

