/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.tag;

import com.qaprosoft.carina.core.foundation.utils.tag.TestPriority;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.testng.ITestContext;
import org.testng.ITestResult;

public class PriorityManager {
    private static final Logger LOGGER = Logger.getLogger(PriorityManager.class);

    private PriorityManager() {
    }

    public static String getPriority(ITestResult result) {
        String priority = PriorityManager.getSuitePriority(result.getTestContext());
        try {
            Method[] possibleMethods;
            Class<?> testClass = Class.forName(result.getMethod().getTestClass().getName());
            String methodName = result.getMethod().getMethodName();
            AccessibleObject testMethod = null;
            for (Method possibleMethod : possibleMethods = testClass.getMethods()) {
                if (!possibleMethod.getName().equals(methodName)) continue;
                testMethod = possibleMethod;
                break;
            }
            if (testMethod != null && testMethod.isAnnotationPresent(TestPriority.class)) {
                TestPriority methodAnnotation = ((Method)testMethod).getAnnotation(TestPriority.class);
                priority = methodAnnotation.value().name();
                LOGGER.debug((Object)("Method '" + testMethod + "' priority is: " + priority));
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return priority;
    }

    private static String getSuitePriority(ITestContext context) {
        String priority = context.getSuite().getParameter("suitePriority");
        LOGGER.debug((Object)("suitePriority is: " + priority));
        if (priority == null) {
            priority = "";
        }
        return priority;
    }
}

