/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.listeners;

import com.qaprosoft.carina.core.foundation.utils.Configuration;
import com.zebrunner.agent.testng.listener.RunContextService;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;

public class TestNamingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final ThreadLocal<String> testName = new ThreadLocal();
    private static final ConcurrentHashMap<String, AtomicInteger> testNameInvCounter = new ConcurrentHashMap();

    @Deprecated
    public static String getTestName() {
        if (testName.get() == null) {
            throw new RuntimeException("Unable to detect full test name yet!");
        }
        return testName.get();
    }

    public static String getTestName(ITestResult result) {
        TestNamingService.setTestName(result);
        return testName.get();
    }

    public static String setTestName(String name) {
        LOGGER.warn("Overridden testName: " + name);
        testName.set(name);
        return testName.get();
    }

    private static String setTestName(ITestResult result) {
        String testHash;
        Object name = "";
        if (result.getTestContext() == null) {
            throw new RuntimeException("Unable to set Test name without testContext!");
        }
        Map testnameMap = (Map)result.getTestContext().getAttribute("testNameArgsMap");
        if (testnameMap != null && testnameMap.containsKey(testHash = String.valueOf(Arrays.hashCode(result.getParameters())))) {
            name = (String)testnameMap.get(testHash);
        }
        if (((String)name).isEmpty()) {
            name = result.getTestContext().getCurrentXmlTest().getName();
        }
        if (result.getTestContext().getCurrentXmlTest().getAllParameters().containsKey("{excel_ds_custom_provider}") || result.getTestContext().getCurrentXmlTest().getAllParameters().containsKey("{ds_custom_provider}")) {
            String methodUID = "";
            for (int i = 0; i < result.getParameters().length; ++i) {
                if (result.getParameters()[i] == null || !result.getParameters()[i].toString().contains("TUID:")) continue;
                methodUID = result.getParameters()[i].toString().replace("TUID:", "");
                break;
            }
            if (!methodUID.isEmpty()) {
                name = methodUID + " - " + (String)name;
            }
        }
        name = (String)name + " - " + TestNamingService.getMethodName(result);
        LOGGER.debug("testName: " + (String)name);
        name = TestNamingService.appendDataProviderLine(result, (String)name);
        name = TestNamingService.appendInvocationCount(result, (String)name);
        testName.set((String)name);
        return testName.get();
    }

    public static String getMethodName(ITestResult result) {
        ITestNGMethod m = result.getMethod();
        String name = Configuration.get(Configuration.Parameter.TEST_NAMING_PATTERN);
        LOGGER.debug("TestNamingPattern: " + name);
        name = name.replace("{method_name}", m.getMethodName());
        name = name.replace("{method_priority}", String.valueOf(m.getPriority()));
        name = name.replace("{method_thread_pool_size}", String.valueOf(m.getThreadPoolSize()));
        if (m.getDescription() != null) {
            LOGGER.debug("Test method description: " + m.getDescription());
            name = name.replace("{method_description}", m.getDescription());
        } else {
            name = name.replace("{method_description}", "");
        }
        return name;
    }

    public static String getPackageName(ITestResult result) {
        return result.getMethod().getRealClass().getPackage().getName();
    }

    private static String appendInvocationCount(ITestResult testResult, String testName) {
        int expectedInvocationCount = TestNamingService.getInvocationCount(testResult);
        if (expectedInvocationCount > 1) {
            int indexMaxLength = Integer.toString(expectedInvocationCount).length() + 1;
            String lineFormat = " [InvCount=%0" + indexMaxLength + "d]";
            int currentInvocationCount = testNameInvCounter.computeIfAbsent((String)testName, $ -> new AtomicInteger(0)).incrementAndGet();
            testName = (String)testName + String.format(lineFormat, currentInvocationCount);
        }
        return testName;
    }

    private static int getInvocationCount(ITestResult testResult) {
        ITestNGMethod[] methods = testResult.getTestContext().getAllTestMethods();
        return Arrays.stream(methods).filter(method -> method.equals(testResult.getMethod())).findFirst().map(ITestNGMethod::getInvocationCount).orElse(0);
    }

    private static String appendDataProviderLine(ITestResult testResult, String testName) {
        ITestNGMethod testMethod = testResult.getMethod();
        ITestContext testContext = testResult.getTestContext();
        Object[] parameters = testResult.getParameters();
        int dataProviderSize = RunContextService.getDataProviderSize((ITestNGMethod)testMethod, (ITestContext)testContext);
        if (dataProviderSize > 0) {
            int indexMaxLength = Integer.toString(dataProviderSize).length() + 1;
            String lineFormat = " [L%0" + indexMaxLength + "d]";
            int index = RunContextService.getCurrentDataProviderIndex((ITestNGMethod)testMethod, (ITestContext)testContext, (Object[])parameters) + 1;
            testName = (String)testName + String.format(lineFormat, index);
        }
        return testName;
    }
}

