/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.report;

import com.qaprosoft.carina.core.foundation.log.ThreadLogAppender;
import com.qaprosoft.carina.core.foundation.utils.Configuration;
import com.qaprosoft.carina.core.foundation.utils.FileManager;
import com.qaprosoft.carina.core.foundation.utils.R;
import com.qaprosoft.carina.core.foundation.utils.ZipManager;
import com.zebrunner.agent.core.registrar.Artifact;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.imgscalr.Scalr;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.testng.Assert;

public class ReportContext {
    private static final Logger LOGGER = Logger.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ARTIFACTS_FOLDER = "artifacts";
    private static final String GALLERY_ZIP = "gallery-lib.zip";
    private static final String REPORT_NAME = "/report.html";
    private static final int MAX_IMAGE_TITLE = 300;
    private static final String TITLE = "Test steps demo";
    public static final String TEMP_FOLDER = "temp";
    private static File baseDirectory = null;
    private static File tempDirectory;
    private static File artifactsDirectory;
    private static File metaDataDirectory;
    private static long rootID;
    private static final ThreadLocal<File> testDirectory;
    private static final ThreadLocal<Boolean> isCustomTestDirName;
    private static final ExecutorService executor;
    private static Map<String, String> screenSteps;

    public static long getRootID() {
        return rootID;
    }

    public static File getBaseDir() {
        try {
            if (baseDirectory == null) {
                boolean isCreated;
                ReportContext.removeOldReports();
                File projectRoot = new File(String.format("%s/%s", URLDecoder.decode(System.getProperty("user.dir"), "utf-8"), Configuration.get(Configuration.Parameter.PROJECT_REPORT_DIRECTORY)));
                if (!projectRoot.exists() && !(isCreated = projectRoot.mkdirs())) {
                    throw new RuntimeException("Folder not created: " + projectRoot.getAbsolutePath());
                }
                rootID = System.currentTimeMillis();
                String directory = String.format("%s/%s/%d", URLDecoder.decode(System.getProperty("user.dir"), "utf-8"), Configuration.get(Configuration.Parameter.PROJECT_REPORT_DIRECTORY), rootID);
                File baseDirectoryTmp = new File(directory);
                boolean isCreated2 = baseDirectoryTmp.mkdir();
                if (!isCreated2) {
                    throw new RuntimeException("Folder not created: " + baseDirectory.getAbsolutePath());
                }
                baseDirectory = baseDirectoryTmp;
                ReportContext.copyGalleryLib();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Folder not created: " + baseDirectory.getAbsolutePath());
        }
        return baseDirectory;
    }

    public static boolean isBaseDirCreated() {
        return baseDirectory != null;
    }

    public static synchronized File getTempDir() {
        boolean isCreated;
        if (tempDirectory == null && !(isCreated = (tempDirectory = new File(String.format("%s/%s", ReportContext.getBaseDir().getAbsolutePath(), TEMP_FOLDER))).mkdir())) {
            throw new RuntimeException("Folder not created: " + tempDirectory.getAbsolutePath());
        }
        return tempDirectory;
    }

    public static synchronized void removeTempDir() {
        if (tempDirectory != null) {
            try {
                FileUtils.deleteDirectory((File)tempDirectory);
            }
            catch (IOException e) {
                LOGGER.debug((Object)"Unable to remove artifacts temp directory!", (Throwable)e);
            }
        }
    }

    public static synchronized File getArtifactsFolder() {
        if (artifactsDirectory == null) {
            boolean isCreated;
            String absolutePath = ReportContext.getBaseDir().getAbsolutePath();
            try {
                artifactsDirectory = Configuration.get(Configuration.Parameter.CUSTOM_ARTIFACTS_FOLDER).isEmpty() ? new File(String.format("%s/%s", URLDecoder.decode(absolutePath, "utf-8"), ARTIFACTS_FOLDER)) : new File(Configuration.get(Configuration.Parameter.CUSTOM_ARTIFACTS_FOLDER));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Artifacts folder not created in base dir: " + absolutePath);
            }
            boolean bl = isCreated = artifactsDirectory.exists() && artifactsDirectory.isDirectory();
            if (!isCreated) {
                isCreated = artifactsDirectory.mkdir();
            } else {
                LOGGER.info((Object)("Artifacts folder already exists: " + artifactsDirectory.getAbsolutePath()));
            }
            if (!isCreated) {
                throw new RuntimeException("Artifacts folder not created: " + artifactsDirectory.getAbsolutePath());
            }
            LOGGER.debug((Object)("Artifacts folder created: " + artifactsDirectory.getAbsolutePath()));
        }
        return artifactsDirectory;
    }

    public static synchronized File getMetadataFolder() {
        if (metaDataDirectory == null) {
            String absolutePath = ReportContext.getBaseDir().getAbsolutePath();
            try {
                metaDataDirectory = new File(String.format("%s/%s/metadata", URLDecoder.decode(absolutePath, "utf-8"), ARTIFACTS_FOLDER));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Artifacts metadata folder is not created in base dir: " + absolutePath);
            }
            boolean isCreated = metaDataDirectory.mkdir();
            if (!isCreated) {
                throw new RuntimeException("Artifacts metadata folder is not created in base dir: " + absolutePath);
            }
        }
        return metaDataDirectory;
    }

    public static boolean isArtifactsFolderExists() {
        try {
            File f = new File(String.format("%s/%s", ReportContext.getBaseDir().getAbsolutePath(), ARTIFACTS_FOLDER));
            if (f.exists() && f.isDirectory()) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Error happen during checking that Artifactory Folder exists or not. Error: " + e.getMessage()));
        }
        return false;
    }

    public static List<File> getAllArtifacts() {
        return Arrays.asList(ReportContext.getArtifactsFolder().listFiles());
    }

    public static File downloadArtifact(WebDriver driver, String name, long timeout) {
        return ReportContext.downloadArtifact(driver, name, timeout, true);
    }

    public static File downloadArtifact(WebDriver driver, String name, long timeout, boolean artifact) {
        File file = ReportContext.getArtifact(name);
        if (file == null) {
            String url = ReportContext.getUrl(driver, name);
            String username = ReportContext.getField(url, 1);
            String password = ReportContext.getField(url, 2);
            if (!ReportContext.artifactExists(driver, name, timeout)) {
                Assert.fail((String)("Unable to find artifact: " + name));
            }
            file = new File(ReportContext.getArtifactsFolder() + File.separator + name);
            String path = file.getAbsolutePath();
            LOGGER.debug((Object)("artifact file to download: " + path));
            if (!username.isEmpty() && !password.isEmpty()) {
                Authenticator.setDefault(new CustomAuthenticator(username, password));
            }
            try {
                FileUtils.copyURLToFile((URL)new URL(url), (File)file);
                LOGGER.debug((Object)("Successfully downloaded artifact: " + name));
                if (artifact) {
                    Artifact.attachToTest((String)name, (File)file);
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)("Artifact: " + url + " wasn't downloaded to " + path), (Throwable)e);
            }
        }
        return file;
    }

    public static boolean artifactExists(WebDriver driver, String name, long timeout) {
        String url = ReportContext.getUrl(driver, name);
        String username = ReportContext.getField(url, 1);
        String password = ReportContext.getField(url, 2);
        try {
            return (Boolean)new WebDriverWait(driver, timeout).until(k -> ReportContext.checkArtifactUsingHttp(url, username, password));
        }
        catch (Exception e) {
            LOGGER.debug((Object)e);
            return false;
        }
    }

    private static boolean checkArtifactUsingHttp(String url, String username, String password) {
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
            con.setRequestMethod("HEAD");
            if (!username.isEmpty() && !password.isEmpty()) {
                String usernameColonPassword = username + ":" + password;
                String basicAuthPayload = "Basic " + Base64.getEncoder().encodeToString(usernameColonPassword.getBytes());
                con.addRequestProperty("Authorization", basicAuthPayload);
            }
            return con.getResponseCode() == 200;
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Artifact doesn't exist: " + url), (Throwable)e);
            return false;
        }
    }

    private static String getField(String url, int position) {
        Pattern pattern = Pattern.compile(".*:\\/\\/(.*):(.*)@");
        Matcher matcher = pattern.matcher(url);
        return matcher.find() ? matcher.group(position) : "";
    }

    private static String getUrl(WebDriver driver, String name) {
        String seleniumHost = Configuration.getSeleniumUrl().replace("wd/hub", "download/");
        WebDriver drv = driver instanceof EventFiringWebDriver ? ((EventFiringWebDriver)driver).getWrappedDriver() : driver;
        String sessionId = ((RemoteWebDriver)drv).getSessionId().toString();
        String url = seleniumHost + sessionId + "/" + name;
        LOGGER.debug((Object)("url: " + url));
        return url;
    }

    public static File getArtifact(String name) {
        File artifact = null;
        for (File file : ReportContext.getAllArtifacts()) {
            if (!file.getName().equals(name)) continue;
            artifact = file;
            break;
        }
        return artifact;
    }

    public static void deleteAllArtifacts() {
        for (File file : ReportContext.getAllArtifacts()) {
            file.delete();
        }
    }

    public static void deleteArtifact(String name) {
        for (File file : ReportContext.getAllArtifacts()) {
            if (!file.getName().equals(name)) continue;
            file.delete();
            break;
        }
    }

    public static void saveArtifact(String name, InputStream source) throws IOException {
        File artifact = new File(String.format("%s/%s", ReportContext.getArtifactsFolder(), name));
        artifact.createNewFile();
        FileUtils.writeByteArrayToFile((File)artifact, (byte[])IOUtils.toByteArray((InputStream)source));
        Artifact.attachToTest((String)name, (byte[])IOUtils.toByteArray((InputStream)source));
    }

    public static void saveArtifact(File source) throws IOException {
        File artifact = new File(String.format("%s/%s", ReportContext.getArtifactsFolder(), source.getName()));
        artifact.createNewFile();
        FileUtils.copyFile((File)source, (File)artifact);
        Artifact.attachToTest((String)source.getName(), (File)artifact);
    }

    public static File getTestDir() {
        return ReportContext.getTestDir("");
    }

    public static File getTestDir(String dirName) {
        File testDir = testDirectory.get();
        if (testDir == null) {
            testDir = ReportContext.createTestDir(dirName);
        }
        return testDir;
    }

    public static synchronized File setCustomTestDirName(String dirName) {
        isCustomTestDirName.set(Boolean.FALSE);
        File testDir = testDirectory.get();
        if (testDir == null) {
            LOGGER.debug((Object)"Test dir will be created.");
            testDir = ReportContext.getTestDir(dirName);
        } else {
            LOGGER.debug((Object)"Test dir will be renamed to custom name.");
            ReportContext.renameTestDir(dirName);
        }
        isCustomTestDirName.set(Boolean.TRUE);
        return testDir;
    }

    public static void emptyTestDirData() {
        testDirectory.remove();
        isCustomTestDirName.set(Boolean.FALSE);
        ReportContext.closeThreadLogAppender();
    }

    public static synchronized File createTestDir() {
        return ReportContext.createTestDir(UUID.randomUUID().toString());
    }

    public static synchronized File createTestDir(String dirName) {
        String directory = String.format("%s/%s", ReportContext.getBaseDir(), dirName);
        File testDir = new File(directory);
        if (!testDir.exists()) {
            testDir.mkdirs();
            if (!testDir.exists()) {
                throw new RuntimeException("Test Folder(s) not created: " + testDir.getAbsolutePath());
            }
        }
        testDirectory.set(testDir);
        return testDir;
    }

    private static void closeThreadLogAppender() {
        try {
            ThreadLogAppender tla = (ThreadLogAppender)Logger.getRootLogger().getAppender("ThreadLogAppender");
            if (tla != null) {
                tla.close();
            }
        }
        catch (NoSuchMethodError e) {
            LOGGER.error((Object)"Exception while closing thread log appender.");
        }
    }

    private static File renameTestDir(String test) {
        File testDir = testDirectory.get();
        ReportContext.initIsCustomTestDir();
        if (testDir != null && !isCustomTestDirName.get().booleanValue()) {
            File newTestDir = new File(String.format("%s/%s", ReportContext.getBaseDir(), test.replaceAll("[^a-zA-Z0-9.-]", "_")));
            if (!newTestDir.exists()) {
                ReportContext.closeThreadLogAppender();
                testDir.renameTo(newTestDir);
                testDirectory.set(newTestDir);
                System.out.println("Test directory is set to : " + newTestDir);
            }
        } else {
            LOGGER.error((Object)("Unexpected case with absence of test.log for '" + test + "'"));
        }
        return testDir;
    }

    private static void initIsCustomTestDir() {
        if (isCustomTestDirName.get() == null) {
            isCustomTestDirName.set(Boolean.FALSE);
        }
    }

    private static void removeOldReports() {
        File baseDir = new File(String.format("%s/%s", System.getProperty("user.dir"), Configuration.get(Configuration.Parameter.PROJECT_REPORT_DIRECTORY)));
        if (baseDir.exists()) {
            File reportFile = new File(String.format("%s/%s/%s", System.getProperty("user.dir"), Configuration.get(Configuration.Parameter.PROJECT_REPORT_DIRECTORY), "emailable-report.html"));
            if (reportFile.exists()) {
                reportFile.delete();
            }
            List<File> files = FileManager.getFilesInDir(baseDir);
            ArrayList<File> screenshotFolders = new ArrayList<File>();
            for (File file : files) {
                if (!file.isDirectory() || file.getName().startsWith(".")) continue;
                screenshotFolders.add(file);
            }
            int maxHistory = Configuration.getInt(Configuration.Parameter.MAX_SCREENSHOOT_HISTORY);
            if (maxHistory > 0 && screenshotFolders.size() + 1 > maxHistory) {
                Comparator<File> comp = new Comparator<File>(){

                    @Override
                    public int compare(File file1, File file2) {
                        return file2.getName().compareTo(file1.getName());
                    }
                };
                Collections.sort(screenshotFolders, comp);
                for (int i = maxHistory - 1; i < screenshotFolders.size(); ++i) {
                    if (((File)screenshotFolders.get(i)).getName().equals("gallery-lib")) continue;
                    try {
                        FileUtils.deleteDirectory((File)((File)screenshotFolders.get(i)));
                        continue;
                    }
                    catch (IOException e) {
                        System.out.println(e + "\n" + e.getMessage());
                    }
                }
            }
        }
    }

    public static void generateHtmlReport(String content) {
        String emailableReport = "emailable-report.html";
        File reportFile = new File(String.format("%s/%s/%s", System.getProperty("user.dir"), Configuration.get(Configuration.Parameter.PROJECT_REPORT_DIRECTORY), emailableReport));
        File reportFileToBaseDir = new File(String.format("%s/%s", ReportContext.getBaseDir(), emailableReport));
        try (FileWriter reportFileWriter = new FileWriter(reportFile.getAbsoluteFile());
             BufferedWriter reportBufferedWriter = new BufferedWriter(reportFileWriter);
             FileWriter baseDirFileWriter = new FileWriter(reportFileToBaseDir.getAbsolutePath());
             BufferedWriter baseDirBufferedWriter = new BufferedWriter(baseDirFileWriter);){
            ReportContext.createNewFileIfNotExists(reportFile);
            reportBufferedWriter.write(content);
            ReportContext.createNewFileIfNotExists(reportFileToBaseDir);
            baseDirBufferedWriter.write(content);
        }
        catch (IOException e) {
            LOGGER.error((Object)"generateHtmlReport failure", (Throwable)e);
        }
    }

    private static void createNewFileIfNotExists(File file) throws IOException {
        boolean isCreated;
        if (!file.exists() && !(isCreated = file.createNewFile())) {
            throw new RuntimeException("File not created: " + file.getAbsolutePath());
        }
    }

    public static String getTestArtifactsLink() {
        String link = "";
        link = !Configuration.get(Configuration.Parameter.REPORT_URL).isEmpty() ? String.format("%s/%d/artifacts", Configuration.get(Configuration.Parameter.REPORT_URL), rootID) : String.format("file://%s/artifacts", ReportContext.getBaseDirAbsolutePath());
        return link;
    }

    public static String getTestScreenshotsLink() {
        String link = "";
        try {
            if (FileUtils.listFiles((File)ReportContext.getTestDir(), (String[])new String[]{"png"}, (boolean)false).isEmpty()) {
                return link;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception during report directory scanning", (Throwable)e);
        }
        String test = testDirectory.get().getName().replaceAll("[^a-zA-Z0-9.-]", "_");
        link = !Configuration.get(Configuration.Parameter.REPORT_URL).isEmpty() ? String.format("%s/%d/%s/report.html", Configuration.get(Configuration.Parameter.REPORT_URL), rootID, test) : String.format("file://%s/%s/report.html", ReportContext.getBaseDirAbsolutePath(), test);
        return link;
    }

    public static String getTestLogLink() {
        String link = "";
        File testLogFile = new File(ReportContext.getTestDir() + "/test.log");
        if (!testLogFile.exists()) {
            return link;
        }
        String test = testDirectory.get().getName().replaceAll("[^a-zA-Z0-9.-]", "_");
        link = !Configuration.get(Configuration.Parameter.REPORT_URL).isEmpty() ? String.format("%s/%d/%s/test.log", Configuration.get(Configuration.Parameter.REPORT_URL), rootID, test) : String.format("file://%s/%s/test.log", ReportContext.getBaseDirAbsolutePath(), test);
        return link;
    }

    public static String getCucumberReportLink() {
        String folder = "cucumber-reports";
        String subFolder = "cucumber-html-reports";
        String fileName = "overview-features.html";
        String link = "";
        if (!Configuration.get(Configuration.Parameter.REPORT_URL).isEmpty()) {
            String report_url = Configuration.get(Configuration.Parameter.REPORT_URL);
            if (report_url.contains("n/a")) {
                LOGGER.error((Object)"Contains n/a. Replace it.");
                report_url = report_url.replace("n/a", "");
            }
            link = String.format("%s/%d/%s/%s/%s", report_url, rootID, folder, subFolder, fileName);
        } else {
            link = String.format("file://%s/%s/%s/%s", ReportContext.getBaseDirAbsolutePath(), folder, subFolder, fileName);
        }
        return link;
    }

    public static String saveScreenshot(BufferedImage screenshot) {
        long now = System.currentTimeMillis();
        executor.execute(new ImageSaverTask(screenshot, String.format("%s/%d.png", ReportContext.getTestDir().getAbsolutePath(), now), Configuration.getInt(Configuration.Parameter.BIG_SCREEN_WIDTH), Configuration.getInt(Configuration.Parameter.BIG_SCREEN_HEIGHT)));
        return String.format("%d.png", now);
    }

    private static void copyGalleryLib() {
        File reportsRootDir = new File(System.getProperty("user.dir") + "/" + Configuration.get(Configuration.Parameter.PROJECT_REPORT_DIRECTORY));
        if (!new File(reportsRootDir.getAbsolutePath() + "/gallery-lib").exists()) {
            try {
                InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream(GALLERY_ZIP);
                if (is == null) {
                    System.out.println("Unable to find in classpath: gallery-lib.zip");
                    return;
                }
                ZipManager.copyInputStream(is, new BufferedOutputStream(new FileOutputStream(reportsRootDir.getAbsolutePath() + "/gallery-lib.zip")));
                ZipManager.unzip(reportsRootDir.getAbsolutePath() + "/gallery-lib.zip", reportsRootDir.getAbsolutePath());
                File zip = new File(reportsRootDir.getAbsolutePath() + "/gallery-lib.zip");
                zip.delete();
            }
            catch (Exception e) {
                System.out.println("Unable to copyGalleryLib! " + e);
            }
        }
    }

    public static void generateTestReport() {
        File testDir = testDirectory.get();
        try {
            List<File> images = FileManager.getFilesInDir(testDir);
            ArrayList<String> imgNames = new ArrayList<String>();
            for (File image : images) {
                imgNames.add(image.getName());
            }
            imgNames.remove("test.log");
            imgNames.remove("sql.log");
            if (imgNames.size() == 0) {
                return;
            }
            Collections.sort(imgNames);
            StringBuilder report = new StringBuilder();
            for (int i = 0; i < imgNames.size(); ++i) {
                String image = R.REPORT.get("image");
                image = image.replace("${image}", (CharSequence)imgNames.get(i));
                String title = ReportContext.getScreenshotComment((String)imgNames.get(i));
                if (title == null) {
                    title = "";
                }
                image = image.replace("${title}", StringUtils.substring((String)title, (int)0, (int)300));
                report.append(image);
            }
            String wholeReport = R.REPORT.get("container").replace("${images}", report.toString());
            wholeReport = wholeReport.replace("${title}", TITLE);
            String folder = testDir.getAbsolutePath();
            FileManager.createFileWithContent(folder + REPORT_NAME, wholeReport);
        }
        catch (Exception e) {
            LOGGER.error((Object)"generateTestReport failure", (Throwable)e);
        }
    }

    public static void addScreenshotComment(String screenId, String msg) {
        if (!StringUtils.isEmpty((CharSequence)screenId)) {
            screenSteps.put(screenId, msg);
        }
    }

    public static String getScreenshotComment(String screenId) {
        String comment = "";
        if (screenSteps.containsKey(screenId)) {
            comment = screenSteps.get(screenId);
        }
        return comment;
    }

    private static String getBaseDirAbsolutePath() {
        if (baseDirectory != null) {
            return baseDirectory.getAbsolutePath();
        }
        return null;
    }

    static {
        testDirectory = new InheritableThreadLocal<File>();
        isCustomTestDirName = new InheritableThreadLocal<Boolean>();
        executor = Executors.newCachedThreadPool();
        screenSteps = Collections.synchronizedMap(new HashMap());
    }

    private static class ImageSaverTask
    implements Runnable {
        private BufferedImage image;
        private String path;
        private Integer width;
        private Integer height;

        public ImageSaverTask(BufferedImage image, String path, Integer width, Integer height) {
            this.image = image;
            this.path = path;
            this.width = width;
            this.height = height;
        }

        @Override
        public void run() {
            try {
                if (this.width > 0 && this.height > 0) {
                    BufferedImage resizedImage = Scalr.resize((BufferedImage)this.image, (Scalr.Method)Scalr.Method.BALANCED, (Scalr.Mode)Scalr.Mode.FIT_TO_WIDTH, (int)this.width, (int)this.height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
                    if (resizedImage.getHeight() > this.height) {
                        resizedImage = Scalr.crop((BufferedImage)resizedImage, (int)resizedImage.getWidth(), (int)this.height, (BufferedImageOp[])new BufferedImageOp[0]);
                    }
                    ImageIO.write((RenderedImage)resizedImage, "PNG", new File(this.path));
                } else {
                    ImageIO.write((RenderedImage)this.image, "PNG", new File(this.path));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unable to save screenshot: " + e.getMessage()));
            }
        }
    }

    public static class CustomAuthenticator
    extends Authenticator {
        String username;
        String password;

        public CustomAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password.toCharArray());
        }
    }
}

