/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils;

import com.qaprosoft.carina.core.foundation.crypto.CryptoTool;
import com.qaprosoft.carina.core.foundation.exception.InvalidConfigurationException;
import com.qaprosoft.carina.core.foundation.utils.Configuration;
import com.qaprosoft.carina.core.foundation.utils.PlaceholderResolver;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum R {
    API("api.properties"),
    CONFIG("config.properties"),
    TESTDATA("testdata.properties"),
    EMAIL("email.properties"),
    REPORT("report.properties"),
    DATABASE("database.properties"),
    ZAFIRA("zafira.properties");

    private static final Logger LOGGER;
    private static final String OVERRIDE_SIGN = "_";
    private static Pattern CRYPTO_PATTERN;
    private String resourceFile;
    private static ThreadLocal<Properties> testProperties;
    private static Map<String, Properties> propertiesHolder;

    public static void reinit() {
        for (R resource : R.values()) {
            try {
                URL overrideResource;
                Properties properties = new Properties();
                URL baseResource = ClassLoader.getSystemResource(resource.resourceFile);
                if (baseResource != null) {
                    properties.load(baseResource.openStream());
                    LOGGER.debug("Base properties loaded: " + resource.resourceFile);
                }
                String resourceName = OVERRIDE_SIGN + resource.resourceFile;
                while ((overrideResource = ClassLoader.getSystemResource(resourceName)) != null) {
                    properties.load(overrideResource.openStream());
                    LOGGER.debug("Override properties loaded: " + resourceName);
                    resourceName = OVERRIDE_SIGN + resourceName;
                }
                for (Object key : properties.keySet()) {
                    String systemValue = System.getProperty((String)key);
                    if (StringUtils.isEmpty((CharSequence)systemValue)) continue;
                    properties.put(key, systemValue);
                }
                if (resource.resourceFile.equals("config.properties")) {
                    if (!CONFIG.isInit(Configuration.Parameter.PROJECT_REPORT_DIRECTORY, properties)) {
                        properties.put(Configuration.Parameter.PROJECT_REPORT_DIRECTORY.getKey(), "./reports");
                    }
                    if (!CONFIG.isInit(Configuration.Parameter.MAX_SCREENSHOOT_HISTORY, properties)) {
                        properties.put(Configuration.Parameter.MAX_SCREENSHOOT_HISTORY.getKey(), "10");
                    }
                }
                if (resource.resourceFile.contains("config.properties")) {
                    String value;
                    String key;
                    String prefix = "capabilities.";
                    HashMap<Object, Object> javaProperties = new HashMap<Object, Object>(System.getProperties());
                    for (Map.Entry entry : javaProperties.entrySet()) {
                        key = (String)entry.getKey();
                        if (!key.toLowerCase().startsWith("capabilities.") || StringUtils.isEmpty((CharSequence)(value = (String)entry.getValue())) || value.equalsIgnoreCase("NULL")) continue;
                        properties.put(key, value);
                    }
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        key = (String)entry.getKey();
                        value = (String)entry.getValue();
                        if (!key.toLowerCase().startsWith("capabilities.") || !StringUtils.isBlank((CharSequence)value) && !value.equalsIgnoreCase("NULL")) continue;
                        properties.remove(key, value);
                    }
                }
                propertiesHolder.put(resource.resourceFile, properties);
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Invalid config in '" + resource + "': " + e.getMessage());
            }
        }
    }

    private boolean isInit(Configuration.Parameter parameter, Properties properties) {
        String value = (String)properties.get(parameter.getKey());
        return value != null && value.length() != 0 && !value.equals("NULL");
    }

    private R(String resourceKey) {
        this.resourceFile = resourceKey;
    }

    public void put(String key, String value) {
        this.put(key, value, false);
    }

    public void put(String key, String value, boolean currentTestOnly) {
        if (currentTestOnly) {
            LOGGER.warn("Override property for current test '" + key + "=" + value + "'!");
            this.getTestProperties().put(key, value);
        } else {
            propertiesHolder.get(this.resourceFile).put(key, value);
        }
    }

    public boolean containsKey(String key) {
        return propertiesHolder.get(this.resourceFile).containsKey(key) || this.getTestProperties().containsKey(key);
    }

    public String get(String key) {
        String value = this.getTestProperties().getProperty(key);
        if (value != null) {
            System.out.println("Overridden '" + key + "=" + value + "' property will be used for current test!");
            return value;
        }
        value = R.CONFIG.resourceFile.equals(this.resourceFile) ? PlaceholderResolver.resolve(propertiesHolder.get(this.resourceFile), key) : propertiesHolder.get(this.resourceFile).getProperty(key);
        return value != null ? value : "";
    }

    public String getDecrypted(String key) {
        return this.decrypt(this.get(key), CRYPTO_PATTERN);
    }

    public int getInt(String key) {
        return Integer.parseInt(this.get(key));
    }

    public long getLong(String key) {
        return Long.parseLong(this.get(key));
    }

    public double getDouble(String key) {
        return Double.parseDouble(this.get(key));
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.get(key));
    }

    public static String getResourcePath(String resource) {
        String path = StringUtils.removeStart((String)ClassLoader.getSystemResource(resource).getPath(), (String)"/");
        path = StringUtils.replaceChars((String)path, (String)"/", (String)"\\");
        path = StringUtils.replaceChars((String)path, (String)"!", (String)"");
        return path;
    }

    public Properties getProperties() {
        Properties globalProp = propertiesHolder.get(this.resourceFile);
        if (!this.getTestProperties().isEmpty()) {
            Properties testProp = testProperties.get();
            LOGGER.debug(String.format("CurrentTestOnly properties has [%s] entries.", testProp.size()));
            LOGGER.debug(testProp.toString());
            HashMap<Object, Object> testCapabilitiesMap = new HashMap<Object, Object>(testProp);
            testCapabilitiesMap.keySet().stream().forEach(i -> {
                if (globalProp.containsKey(i)) {
                    LOGGER.debug(String.format("Global properties already contains key --- %s --- with value --- %s ---. Global property will be overridden by  --- %s --- from test properties.", i, globalProp.get(i), testProp.get(i)));
                } else {
                    LOGGER.debug(String.format("Global properties isn't contains key --- %s ---.  Global key --- %s --- will be set to --- %s ---  from test properties.", i, i, testProp.get(i)));
                }
                globalProp.setProperty((String)i, (String)testProp.get(i));
            });
        }
        return globalProp;
    }

    public void clearTestProperties() {
        testProperties.remove();
    }

    public Properties getTestProperties() {
        if (testProperties.get() == null) {
            Properties properties = new Properties();
            testProperties.set(properties);
        }
        return testProperties.get();
    }

    private String decrypt(String content, Pattern pattern) {
        try {
            CryptoTool cryptoTool = new CryptoTool(Configuration.get(Configuration.Parameter.CRYPTO_KEY_PATH));
            return cryptoTool.decryptByPattern(content, pattern);
        }
        catch (Exception e) {
            LOGGER.error("Error during decrypting '" + content + "'. Please check error: ", (Throwable)e);
            return content;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        CRYPTO_PATTERN = Pattern.compile("\\{crypt:[^\\{\\}]*\\}");
        testProperties = new ThreadLocal();
        propertiesHolder = new HashMap<String, Properties>();
        R.reinit();
    }
}

