/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.android.recorder.utils;

import com.qaprosoft.carina.core.foundation.utils.Configuration;
import com.qaprosoft.carina.core.foundation.utils.android.recorder.utils.ProcessBuilderExecutor;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdbExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static String[] cmdInit;

    public AdbExecutor() {
        cmdInit = "adb".split(" ");
    }

    public String[] getDefaultCmd() {
        return cmdInit;
    }

    public List<String> execute(String[] cmd) {
        ProcessBuilderExecutor executor = null;
        BufferedReader in = null;
        ArrayList<String> output = new ArrayList<String>();
        try {
            executor = new ProcessBuilderExecutor(cmd);
            Process process = executor.start();
            if (!process.waitFor(Configuration.getAdbExecTimeout(), TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Waiting time elapsed before the adb execution command has exited");
            }
            in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = in.readLine()) != null) {
                output.add(line);
                LOGGER.debug(line);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                AdbExecutor.closeQuietly(in);
                ProcessBuilderExecutor.gcNullSafe(executor);
                throw throwable;
            }
        }
        AdbExecutor.closeQuietly(in);
        ProcessBuilderExecutor.gcNullSafe(executor);
        return output;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

