/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.android.recorder.utils;

import com.qaprosoft.carina.core.foundation.utils.android.recorder.exception.ExecutorException;
import com.qaprosoft.carina.core.foundation.utils.android.recorder.utils.Platform;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessBuilderExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Map<Integer, Process> runPIDs = new HashMap<Integer, Process>();
    private Process process;
    private int pid;
    private boolean alreadyPerformed;
    private String[] cmd;
    private ProcessBuilder pb;

    public ProcessBuilderExecutor(String ... cmd) {
        this.cmd = cmd;
        this.alreadyPerformed = false;
    }

    private ProcessBuilder getProcessBuilder() {
        if (this.pb == null) {
            this.pb = new ProcessBuilder(this.cmd);
        }
        return this.pb;
    }

    public List<String> getCommand() {
        return this.getProcessBuilder().command();
    }

    public Map<String, String> getEnvironment() {
        return this.getProcessBuilder().environment();
    }

    public int getPID() throws ExecutorException {
        if (!this.alreadyPerformed) {
            throw new ExecutorException("Process not started yet.");
        }
        return this.pid;
    }

    public Process start() throws ExecutorException {
        if (this.alreadyPerformed) {
            throw new ExecutorException("Multiple execution attempt.");
        }
        ProcessBuilder pb = this.getProcessBuilder();
        LOGGER.debug("trying to execute:  " + pb.command());
        try {
            this.process = pb.start();
            this.pid = Platform.getPID(this.process);
            ProcessBuilderExecutor.addToGlobalGC(this.process, this.pid);
            Process process = this.process;
            return process;
        }
        catch (Exception e) {
            throw new ExecutorException(e.getMessage(), e);
        }
        finally {
            this.alreadyPerformed = true;
            LOGGER.debug("Process started. PID = " + this.pid);
        }
    }

    public void gc() {
        ProcessBuilderExecutor.destroyProcess(this.process);
    }

    protected void finalize() throws Throwable {
        try {
            this.gc();
        }
        finally {
            super.finalize();
        }
    }

    public static void gcNullSafe(ProcessBuilderExecutor executor) {
        if (executor != null) {
            executor.gc();
        }
    }

    private static void destroyProcess(Process process) {
        if (process == null) {
            return;
        }
        InputStream is = process.getInputStream();
        InputStream err = process.getErrorStream();
        OutputStream out = process.getOutputStream();
        process.destroy();
        ProcessBuilderExecutor.closeQuietly(is);
        ProcessBuilderExecutor.closeQuietly(err);
        ProcessBuilderExecutor.closeQuietly(out);
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToGlobalGC(Process process, int pid) {
        Class<ProcessBuilderExecutor> clazz = ProcessBuilderExecutor.class;
        synchronized (ProcessBuilderExecutor.class) {
            runPIDs.put(pid, process);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gcGlobal() {
        Class<ProcessBuilderExecutor> clazz = ProcessBuilderExecutor.class;
        synchronized (ProcessBuilderExecutor.class) {
            Collection<Process> processes = runPIDs.values();
            LOGGER.debug("perform process cleaning ... (" + processes.size() + " processes need to destroy)");
            for (Process p : processes) {
                ProcessBuilderExecutor.destroyProcess(p);
            }
            Platform.killProcesses(runPIDs.keySet());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

