/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.marshaller;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Marshaller {
    private static Marshaller instance;
    private final Map<Class<?>, JAXBContext> contextCache = new HashMap();
    private static final Logger LOGGER;

    private Marshaller() {
    }

    static Marshaller getInstance() {
        if (null == instance) {
            instance = new Marshaller();
        }
        return instance;
    }

    private JAXBContext getJAXBContext(Class<?> clazz) {
        try {
            if (!this.contextCache.containsKey(clazz)) {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
                this.contextCache.put(clazz, context);
                return context;
            }
            return this.contextCache.get(clazz);
        }
        catch (JAXBException e) {
            LOGGER.error("Cant create new instance of JAXBContext!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private javax.xml.bind.Marshaller getMarshaller(Class<?> clazz) {
        try {
            javax.xml.bind.Marshaller marshaller = this.getJAXBContext(clazz).createMarshaller();
            return marshaller;
        }
        catch (JAXBException e) {
            LOGGER.error("Error while creating marshaller!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Unmarshaller getUnmarshaller(Class<?> clazz) {
        try {
            Unmarshaller unmarshaller = this.getJAXBContext(clazz).createUnmarshaller();
            return unmarshaller;
        }
        catch (JAXBException e) {
            LOGGER.error("Error while creating unmarshaller!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public <T> T unmarshall(Source source, Class<T> resultClazz) {
        try {
            return (T)this.getUnmarshaller(resultClazz).unmarshal(source);
        }
        catch (JAXBException e) {
            LOGGER.error("Error while unmarshalling!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public <T> T unmarshall(String string, Class<T> resultClazz) {
        try {
            return (T)this.getUnmarshaller(resultClazz).unmarshal((InputStream)new ByteArrayInputStream(string.getBytes()));
        }
        catch (JAXBException e) {
            LOGGER.error("Error while unmarshalling!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public <T> T unmarshall(File file, Class<T> resultClazz) {
        try {
            return (T)this.getUnmarshaller(resultClazz).unmarshal(file);
        }
        catch (JAXBException e) {
            LOGGER.error("Error while unmarshalling!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public <T> T unmarshall(InputStream is, Class<T> resultClazz) {
        try {
            return (T)this.getUnmarshaller(resultClazz).unmarshal(is);
        }
        catch (JAXBException e) {
            LOGGER.error("Error while unmarshalling", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void marshall(Object jaxbElement, Result paramResult) {
        try {
            this.getMarshaller(jaxbElement.getClass()).marshal(jaxbElement, paramResult);
        }
        catch (JAXBException e) {
            LOGGER.error("Error while marshalling!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void marshall(Object jaxbElement, Writer writer) {
        try {
            this.getMarshaller(jaxbElement.getClass()).marshal(jaxbElement, writer);
        }
        catch (JAXBException e) {
            LOGGER.error("Error while marshalling!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String marshall(Object jaxbElement) {
        try {
            StringWriter w = new StringWriter();
            this.getMarshaller(jaxbElement.getClass()).marshal(jaxbElement, (Writer)w);
            return w.toString();
        }
        catch (JAXBException e) {
            LOGGER.error("Error while marshalling!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }
}

