/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.mobile.notifications;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.qaprosoft.carina.core.foundation.utils.rest.RestUtil;
import io.restassured.response.Response;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static JsonObject callPushService(String contentType, Map<String, ?> parameters, String url) {
        return NotificationUtils.callPushService(contentType, parameters, url, true);
    }

    public static JsonObject callPushService(String contentType, Map<String, ?> parameters, String url, boolean responseLog) {
        try {
            LOGGER.info("Request url: " + url);
            Response response = RestUtil.sendHttpPost(contentType, parameters, url.toString(), responseLog);
            if (response.getStatusCode() == 200) {
                LOGGER.debug("Call passed with status code '" + response.getStatusCode() + "'. ");
                JsonParser parser = new JsonParser();
                return parser.parse(response.asString()).getAsJsonObject();
            }
            LOGGER.error("Call failed with status code '" + response.getStatusCode() + "'. ");
        }
        catch (Exception e) {
            LOGGER.error("callPushService failure", (Throwable)e);
        }
        return null;
    }

    public static JsonObject getPushServiceResponse(String request, String url) {
        return NotificationUtils.getPushServiceResponse("application/json", request, url, true);
    }

    public static JsonObject getPushServiceResponse(String contentType, String request, String url, boolean responseLog) {
        try {
            LOGGER.info("Request url: " + url);
            Response response = RestUtil.sendHttpPost(contentType, request, url.toString(), responseLog);
            if (response.getStatusCode() == 200) {
                LOGGER.debug("Call passed with status code '" + response.getStatusCode() + "'. ");
                JsonParser parser = new JsonParser();
                return parser.parse(response.asString()).getAsJsonObject();
            }
            LOGGER.error("Call failed with status code '" + response.getStatusCode() + "'. ");
        }
        catch (Exception e) {
            LOGGER.error("getPushServiceResponse failure", (Throwable)e);
        }
        return null;
    }

    public static JsonObject getGetServiceResponse(String url) {
        return NotificationUtils.getGetServiceResponse("application/json", url, true);
    }

    public static JsonObject getGetServiceResponse(String contentType, String url, boolean responseLog) {
        try {
            LOGGER.info("Request url: " + url);
            Response response = RestUtil.sendHttpGet(contentType, url.toString(), responseLog);
            if (response.getStatusCode() == 200) {
                LOGGER.debug("Call passed with status code '" + response.getStatusCode() + "'. ");
                JsonParser parser = new JsonParser();
                return parser.parse(response.asString()).getAsJsonObject();
            }
            LOGGER.error("Call failed with status code '" + response.getStatusCode() + "'. ");
        }
        catch (Exception e) {
            LOGGER.error("getGetServiceResponse failure", (Throwable)e);
        }
        return null;
    }
}

