/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.ownership;

import com.qaprosoft.carina.core.foundation.utils.Configuration;
import com.qaprosoft.carina.core.foundation.utils.ownership.MethodOwner;
import com.zebrunner.agent.core.registrar.maintainer.MaintainerResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;

public class Ownership
implements MaintainerResolver {
    private String owner = "";

    public Ownership(String owner) {
        if (owner != null) {
            this.owner = owner;
        }
    }

    public Ownership() {
        this("");
    }

    public String resolve(Class<?> clazz, Method method) {
        String actualPlatform;
        Annotation methodAnnotation;
        Method[] possibleMethods;
        String methodName = method.getName();
        AccessibleObject testMethod = null;
        for (Method possibleMethod : possibleMethods = clazz.getMethods()) {
            if (!possibleMethod.getName().equals(methodName)) continue;
            testMethod = possibleMethod;
            break;
        }
        if (testMethod != null && testMethod.isAnnotationPresent(MethodOwner.class)) {
            methodAnnotation = ((Method)testMethod).getAnnotation(MethodOwner.class);
            this.owner = methodAnnotation.owner();
        }
        if (testMethod != null && testMethod.isAnnotationPresent(MethodOwner.List.class)) {
            methodAnnotation = ((Method)testMethod).getAnnotation(MethodOwner.List.class);
            for (MethodOwner methodOwner : methodAnnotation.value()) {
                actualPlatform = methodOwner.platform();
                if (!actualPlatform.isEmpty()) continue;
                this.owner = methodOwner.owner();
                break;
            }
        }
        if (testMethod != null && testMethod.isAnnotationPresent(MethodOwner.List.class)) {
            methodAnnotation = ((Method)testMethod).getAnnotation(MethodOwner.List.class);
            for (MethodOwner methodOwner : methodAnnotation.value()) {
                actualPlatform = methodOwner.platform();
                String expectedPlatform = Configuration.getPlatform();
                if (actualPlatform.isEmpty() || !Ownership.isValidPlatform(actualPlatform, expectedPlatform)) continue;
                this.owner = methodOwner.owner();
            }
        }
        return this.owner;
    }

    private static boolean isValidPlatform(String actualPlatform, String expectedPlatform) {
        return actualPlatform.equalsIgnoreCase(expectedPlatform);
    }
}

