/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.resources;

import com.qaprosoft.carina.core.foundation.utils.Configuration;
import com.qaprosoft.carina.core.foundation.utils.IWebElement;
import com.qaprosoft.carina.core.foundation.utils.resources.ResourceURLFilter;
import com.qaprosoft.carina.core.foundation.utils.resources.Resources;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.asserts.SoftAssert;

public class L10N {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Locale locale = L10N.getLocale(Configuration.get(Configuration.Parameter.LOCALE));
    private static ArrayList<ResourceBundle> resBoundles = new ArrayList();
    private static Properties missedResources = new Properties();
    private static SoftAssert mistakes = new SoftAssert();

    public static void load() {
        ArrayList<CallSite> loadedResources = new ArrayList<CallSite>();
        try {
            for (URL u : Resources.getResourceURLs(new ResourceURLFilter(){

                @Override
                public boolean accept(URL u) {
                    String s = u.getPath();
                    boolean contains = s.contains("L10N");
                    if (contains) {
                        LOGGER.debug("L10N: file URL: " + u);
                    }
                    return contains;
                }
            })) {
                LOGGER.debug(String.format("Analyzing '%s' L10N resource for loading...", u));
                String fileName = FilenameUtils.getBaseName((String)u.getPath());
                if (u.getPath().endsWith("L10N.class") || u.getPath().endsWith("L10N$1.class")) continue;
                if (fileName.lastIndexOf(95) == fileName.length() - 3 || fileName.lastIndexOf(95) == fileName.length() - 5) {
                    LOGGER.debug(String.format("'%s' resource IGNORED as it looks like localized resource!", fileName));
                    continue;
                }
                String filePath = FilenameUtils.getPath((String)u.getPath());
                int index = filePath.indexOf("L10N");
                if (index == -1) {
                    LOGGER.warn("Unable to find L10N pattern for " + u.getPath() + " resource!");
                    continue;
                }
                String resource = filePath.substring(filePath.indexOf("L10N")).replaceAll("/", ".") + fileName;
                if (!loadedResources.contains(resource)) {
                    loadedResources.add((CallSite)((Object)resource));
                    try {
                        LOGGER.debug(String.format("Adding '%s' resource...", resource));
                        resBoundles.add(ResourceBundle.getBundle(resource, locale));
                        LOGGER.debug(String.format("Resource '%s' added.", resource));
                    }
                    catch (MissingResourceException e) {
                        LOGGER.debug("No resource bundle for the " + resource + " can be found", (Throwable)e);
                    }
                    continue;
                }
                LOGGER.debug(String.format("Requested resource '%s' is already loaded into the ResourceBundle!", resource));
            }
            LOGGER.debug("init: L10N bundle size: " + resBoundles.size());
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("L10N folder with resources is missing!");
        }
    }

    public static void load(ArrayList<ResourceBundle> resources) {
        resBoundles = resources;
    }

    public static String getText(String key) {
        LOGGER.debug("getText: L10N bundle size: " + resBoundles.size());
        for (ResourceBundle bundle : resBoundles) {
            try {
                String value = bundle.getString(key);
                if (!bundle.getLocale().toString().equals(locale.toString())) continue;
                return value;
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return key;
    }

    public static boolean verify(IWebElement element) {
        String key;
        String expectedText;
        boolean isValid;
        if (!Configuration.getBoolean(Configuration.Parameter.LOCALIZATION_TESTING)) {
            return true;
        }
        String actualText = element.getText();
        boolean bl = isValid = actualText.contains(expectedText = L10N.getText(key = element.getName())) && !expectedText.isEmpty();
        if (!isValid) {
            String error = "Expected: '" + expectedText + "', length=" + expectedText.length() + ". Actual: '" + actualText + "', length=" + actualText.length() + ".";
            LOGGER.error(error);
            mistakes.fail(error);
            String newItem = key + "=" + actualText;
            LOGGER.info("Making new localization string: " + newItem);
            missedResources.setProperty(key, actualText);
        } else {
            LOGGER.debug("Found localization text '" + actualText + " in +" + L10N.getEncoding() + " encoding: " + expectedText);
        }
        return isValid;
    }

    public static void assertAll() {
        mistakes.assertAll();
    }

    public static void setLocale(String loc) {
        LOGGER.warn("Default locale: " + locale + " was overriden by " + loc);
        locale = L10N.getLocale(loc);
    }

    public static void flush() {
        if (missedResources.size() == 0) {
            LOGGER.info("There are no new localization properties.");
            return;
        }
        LOGGER.info("New localization for '" + locale + "'");
        LOGGER.info("Properties: " + missedResources.toString());
        String missedResorceFile = "missed_" + locale + ".properties";
        try {
            missedResources.store(new OutputStreamWriter((OutputStream)new FileOutputStream(missedResorceFile), L10N.getEncoding()), null);
        }
        catch (Exception e) {
            LOGGER.error("Unable to store missed resources: " + missedResorceFile + "!", (Throwable)e);
        }
        missedResources.clear();
    }

    private static String getEncoding() {
        return Configuration.get(Configuration.Parameter.LOCALIZATION_ENCODING).toUpperCase();
    }

    private static Locale getLocale(String locale) {
        String[] localeSetttings = locale.trim().split("_");
        String country = "";
        String lang = localeSetttings[0];
        if (localeSetttings.length > 1) {
            country = localeSetttings[1];
        }
        return new Locale(lang, country);
    }
}

