/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.resources;

import com.qaprosoft.carina.core.foundation.utils.resources.ResourceURLFilter;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resources {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private static void collectURL(ResourceURLFilter f, Set<URL> s, URL u) {
        if (f == null || f.accept(u)) {
            LOGGER.debug("adding resource url by filter: " + u);
            s.add(u);
        }
    }

    private static void iterateFileSystem(File r, ResourceURLFilter f, Set<URL> s) {
        File[] files;
        for (File file : files = r.listFiles()) {
            if (file.isDirectory()) {
                Resources.iterateFileSystem(file, f, s);
                continue;
            }
            if (!file.isFile()) continue;
            try {
                Resources.collectURL(f, s, file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                LOGGER.debug("Error while collecting urls!", (Throwable)e);
            }
        }
    }

    private static void iterateEntry(File p, ResourceURLFilter f, Set<URL> s) {
        if (p.isDirectory()) {
            Resources.iterateFileSystem(p, f, s);
        }
    }

    public static Set<URL> getResourceURLs() {
        return Resources.getResourceURLs((ResourceURLFilter)null);
    }

    public static Set<URL> getResourceURLs(Class rootClass) {
        return Resources.getResourceURLs(rootClass, null);
    }

    public static Set<URL> getResourceURLs(ResourceURLFilter filter) {
        HashSet<URL> throwable;
        HashSet<URL> collectedURLs = new HashSet<URL>();
        URLClassLoader ucl = new URLClassLoader(new URL[]{ClassLoader.getSystemClassLoader().getResource("L10N")}, Resources.class.getClassLoader());
        try {
            for (URL url : ucl.getURLs()) {
                try {
                    Resources.iterateEntry(new File(url.toURI()), filter, collectedURLs);
                }
                catch (URISyntaxException e) {
                    LOGGER.debug("Error during creating URI from url!", (Throwable)e);
                }
            }
            throwable = collectedURLs;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    ucl.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            catch (IOException e) {
                LOGGER.debug("Error on creating URLClassLoader!", (Throwable)e);
                return collectedURLs;
            }
        }
        ucl.close();
        return throwable;
    }

    public static Set<URL> getResourceURLs(Class rootClass, ResourceURLFilter filter) {
        HashSet<URL> collectedURLs = new HashSet<URL>();
        CodeSource src = rootClass.getProtectionDomain().getCodeSource();
        try {
            Resources.iterateEntry(new File(src.getLocation().toURI()), filter, collectedURLs);
        }
        catch (URISyntaxException e) {
            LOGGER.debug("Error during creating URI from url!", (Throwable)e);
        }
        return collectedURLs;
    }
}

