/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.qaprosoft.zafira.models.stf.Devices;
import com.qaprosoft.zafira.models.stf.RemoteConnectUserDevice;
import com.qaprosoft.zafira.models.stf.Response;
import com.qaprosoft.zafira.models.stf.STFDevice;
import com.sun.jersey.api.client.Client;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STFClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(STFClient.class);
    private static final Integer TIMEOUT = 3600000;
    private static final String DEVICES_PATH = "/api/v1/devices";
    private static final String USER_DEVICES_PATH = "/api/v1/user/devices";
    private static final String USER_DEVICES_BY_ID_PATH = "/api/v1/user/devices/%s";
    private static final String USER_DEVICES_REMOTE_CONNECT_PATH = "/api/v1/user/devices/%s/remoteConnect";
    private Client client;
    private String serviceURL;
    private String authToken;

    public STFClient(String serviceURL, String authToken) {
        this.serviceURL = serviceURL;
        this.authToken = authToken;
        this.client = Client.create();
        this.client.setConnectTimeout(TIMEOUT);
        this.client.setReadTimeout(TIMEOUT);
    }

    public Response<Devices> getAllDevices() {
        Response result = new Response(0, null);
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet request = new HttpGet(this.serviceURL + DEVICES_PATH);
            request.addHeader("Authorization", "Bearer " + this.authToken);
            HttpResponse response = client.execute((HttpUriRequest)request);
            int status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                ObjectMapper mapper = new ObjectMapper();
                Devices devices = (Devices)mapper.readValue(response.getEntity().getContent(), Devices.class);
                result.setStatus(status);
                result.setObject((Object)devices);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return result;
    }

    public Response<STFDevice> getDevice(String udid) {
        Response result = new Response(0, null);
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet request = new HttpGet(this.serviceURL + DEVICES_PATH + "/" + udid);
            request.addHeader("Authorization", "Bearer " + this.authToken);
            HttpResponse response = client.execute((HttpUriRequest)request);
            int status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                ObjectMapper mapper = new ObjectMapper();
                JSONObject json = new JSONObject(IOUtils.toString((InputStream)response.getEntity().getContent()));
                STFDevice device = (STFDevice)mapper.readValue(json.getString("device"), STFDevice.class);
                result.setStatus(status);
                result.setObject((Object)device);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return result;
    }

    public boolean reserveDevice(String serial, long timeout) {
        boolean isSuccess = false;
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpPost request = new HttpPost(this.serviceURL + USER_DEVICES_PATH);
            request.addHeader("Authorization", "Bearer " + this.authToken);
            StringEntity entity = new StringEntity("{\"serial\":\"" + serial + "\"}");
            entity.setContentType("application/json");
            request.setEntity((HttpEntity)entity);
            HttpResponse response = client.execute((HttpUriRequest)request);
            isSuccess = response.getStatusLine().getStatusCode() == 200;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return isSuccess;
    }

    public boolean returnDevice(String serial) {
        boolean isSuccess = false;
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpDelete request = new HttpDelete(this.serviceURL + String.format(USER_DEVICES_BY_ID_PATH, serial));
            request.addHeader("Authorization", "Bearer " + this.authToken);
            HttpResponse response = client.execute((HttpUriRequest)request);
            isSuccess = response.getStatusLine().getStatusCode() == 200;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return isSuccess;
    }

    public Response<RemoteConnectUserDevice> remoteConnectDevice(String serial) {
        Response result = new Response(0, null);
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpPost request = new HttpPost(this.serviceURL + String.format(USER_DEVICES_REMOTE_CONNECT_PATH, serial));
            request.addHeader("Authorization", "Bearer " + this.authToken);
            HttpResponse response = client.execute((HttpUriRequest)request);
            int status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                ObjectMapper mapper = new ObjectMapper();
                RemoteConnectUserDevice devices = (RemoteConnectUserDevice)mapper.readValue(response.getEntity().getContent(), RemoteConnectUserDevice.class);
                result.setStatus(status);
                result.setObject((Object)devices);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public boolean remoteDisconnectDevice(String serial) {
        boolean isSuccess = false;
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpPost request = new HttpPost(this.serviceURL + String.format(USER_DEVICES_REMOTE_CONNECT_PATH, serial));
            request.addHeader("Authorization", "Bearer " + this.authToken);
            HttpResponse response = client.execute((HttpUriRequest)request);
            isSuccess = response.getStatusLine().getStatusCode() == 200;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return isSuccess;
    }

    public boolean isConnected() {
        boolean isSuccess = false;
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet request = new HttpGet(this.serviceURL + DEVICES_PATH);
            request.addHeader("Authorization", "Bearer " + this.authToken);
            HttpResponse response = client.execute((HttpUriRequest)request);
            isSuccess = response.getStatusLine().getStatusCode() == 200;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return isSuccess;
    }
}

