/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.client;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.internal.SdkBufferedInputStream;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.qaprosoft.zafira.config.CIConfig;
import com.qaprosoft.zafira.config.GensonProvider;
import com.qaprosoft.zafira.models.db.Status;
import com.qaprosoft.zafira.models.db.TestRun;
import com.qaprosoft.zafira.models.dto.JobType;
import com.qaprosoft.zafira.models.dto.ProjectType;
import com.qaprosoft.zafira.models.dto.TagType;
import com.qaprosoft.zafira.models.dto.TestArtifactType;
import com.qaprosoft.zafira.models.dto.TestCaseType;
import com.qaprosoft.zafira.models.dto.TestRunType;
import com.qaprosoft.zafira.models.dto.TestSuiteType;
import com.qaprosoft.zafira.models.dto.TestType;
import com.qaprosoft.zafira.models.dto.auth.AccessTokenType;
import com.qaprosoft.zafira.models.dto.auth.AuthTokenType;
import com.qaprosoft.zafira.models.dto.auth.CredentialsType;
import com.qaprosoft.zafira.models.dto.auth.RefreshTokenType;
import com.qaprosoft.zafira.models.dto.auth.TenantType;
import com.qaprosoft.zafira.models.dto.aws.PresignedUrlRequest;
import com.qaprosoft.zafira.models.dto.aws.SessionCredentials;
import com.qaprosoft.zafira.models.dto.user.UserType;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZafiraClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZafiraClient.class);
    public static final String DEFAULT_USER = "anonymous";
    public static final String DEFAULT_PROJECT = "UNKNOWN";
    private static final Integer CONNECT_TIMEOUT = 30000;
    private static final Integer READ_TIMEOUT = 30000;
    private static final String STATUS_PATH = "/api/status";
    private static final String PROFILE_PATH = "/api/users/profile";
    private static final String LOGIN_PATH = "/api/auth/login";
    private static final String ACCESS_PATH = "/api/auth/access";
    private static final String REFRESH_TOKEN_PATH = "/api/auth/refresh";
    private static final String USERS_PATH = "/api/users";
    private static final String JOBS_PATH = "/api/jobs";
    private static final String TESTS_PATH = "/api/tests";
    private static final String TEST_FINISH_PATH = "/api/tests/%d/finish";
    private static final String TEST_BY_ID_PATH = "/api/tests/%d";
    private static final String TEST_WORK_ITEMS_PATH = "/api/tests/%d/workitems";
    private static final String TEST_ARTIFACTS_PATH = "/api/tests/%d/artifacts";
    private static final String TEST_SUITES_PATH = "/api/tests/suites";
    private static final String TEST_CASES_PATH = "/api/tests/cases";
    private static final String TEST_CASES_BATCH_PATH = "/api/tests/cases/batch";
    private static final String TEST_RUNS_PATH = "/api/tests/runs";
    private static final String TEST_RUNS_FINISH_PATH = "/api/tests/runs/%d/finish";
    private static final String TEST_RUNS_RESULTS_PATH = "/api/tests/runs/%d/results";
    private static final String TEST_RUNS_ABORT_PATH = "/api/tests/runs/abort?id=%d";
    private static final String TEST_RUN_BY_ID_PATH = "/api/tests/runs/%d";
    private static final String SETTINGS_TOOL_PATH = "/api/settings/tool/%s";
    private static final String AMAZON_SESSION_CREDENTIALS_PATH = "/api/settings/amazon/creds";
    private static final String AMAZON_PRESIGNED_URL_PATH = "/api/settings/amazon/presignedURL";
    private static final String TENANT_TYPE_PATH = "/api/auth/tenant";
    private static final String PROJECTS_PATH = "/api/projects/%s";
    private String serviceURL;
    private Client client;
    private String authToken;
    private String project = "UNKNOWN";
    private AmazonS3 amazonClient;
    private SessionCredentials amazonS3SessionCredentials;
    private TenantType tenantType;

    public ZafiraClient(String serviceURL) {
        this.serviceURL = serviceURL;
        this.client = Client.create((ClientConfig)new DefaultClientConfig(new Class[]{GensonProvider.class}));
        this.client.setConnectTimeout(CONNECT_TIMEOUT);
        this.client.setReadTimeout(READ_TIMEOUT);
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public boolean isAvailable() {
        boolean isAvailable = false;
        try {
            WebResource webResource = this.client.resource(this.serviceURL + STATUS_PATH);
            ClientResponse clientRS = (ClientResponse)webResource.get(ClientResponse.class);
            if (clientRS.getStatus() == 200) {
                isAvailable = true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to send ping", (Throwable)e);
        }
        return isAvailable;
    }

    public synchronized Response<UserType> getUserProfile() {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + PROFILE_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(UserType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to authorize user", (Throwable)e);
        }
        return response;
    }

    public synchronized Response<UserType> getUserProfile(String username) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + PROFILE_PATH + "?username=" + username);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(UserType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to authorize user", (Throwable)e);
        }
        return response;
    }

    public synchronized Response<AuthTokenType> login(String username, String password) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + LOGIN_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)new CredentialsType(username, password));
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(AuthTokenType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to login", (Throwable)e);
        }
        return response;
    }

    public synchronized Response<AccessTokenType> generateAccessToken() {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + ACCESS_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(AccessTokenType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to generate access token", (Throwable)e);
        }
        return response;
    }

    public synchronized Response<UserType> createUser(UserType user) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + USERS_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).put(ClientResponse.class, (Object)user);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(UserType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to create user", (Throwable)e);
        }
        return response;
    }

    public synchronized Response<AuthTokenType> refreshToken(String token) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + REFRESH_TOKEN_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)new RefreshTokenType(token));
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(AuthTokenType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to create user", (Throwable)e);
        }
        return response;
    }

    public synchronized Response<JobType> createJob(JobType job) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + JOBS_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)job);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(JobType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to create job", (Throwable)e);
        }
        return response;
    }

    public synchronized Response<TestSuiteType> createTestSuite(TestSuiteType testSuite) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + TEST_SUITES_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)testSuite);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestSuiteType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to create test suite", (Throwable)e);
        }
        return response;
    }

    public Response<TestRunType> startTestRun(TestRunType testRun) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + TEST_RUNS_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)testRun);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestRunType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to start test run", (Throwable)e);
        }
        return response;
    }

    public Response<TestRunType> updateTestRun(TestRunType testRun) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + TEST_RUNS_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).put(ClientResponse.class, (Object)testRun);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestRunType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to update test run", (Throwable)e);
        }
        return response;
    }

    public Response<TestRunType> finishTestRun(long id) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(TEST_RUNS_FINISH_PATH, id));
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestRunType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to finish test run", (Throwable)e);
        }
        return response;
    }

    public Response<TestRunType> getTestRun(long id) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(TEST_RUN_BY_ID_PATH, id));
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestRunType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to find test run by id", (Throwable)e);
        }
        return response;
    }

    public Response<TestRunType> getTestRunByCiRunId(String ciRunId) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + TEST_RUNS_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.queryParam("ciRunId", ciRunId).type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestRunType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable find test run by CI run id", (Throwable)e);
        }
        return response;
    }

    public Response<TestType> startTest(TestType test) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + TESTS_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)test);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to start test", (Throwable)e);
        }
        return response;
    }

    public Response<TestType> finishTest(TestType test) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(TEST_FINISH_PATH, test.getId()));
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)test);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to finish test", (Throwable)e);
        }
        return response;
    }

    public void deleteTest(long id) {
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(TEST_BY_ID_PATH, id));
            webResource.delete(ClientResponse.class);
        }
        catch (Exception e) {
            LOGGER.error("Unable to finish test", (Throwable)e);
        }
    }

    public Response<TestType> createTestWorkItems(long testId, List<String> workItems) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(TEST_WORK_ITEMS_PATH, testId));
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, workItems);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to create test work items", (Throwable)e);
        }
        return response;
    }

    public void addTestArtifact(TestArtifactType artifact) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(TEST_ARTIFACTS_PATH, artifact.getTestId()));
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)artifact);
            response.setStatus(clientRS.getStatus());
        }
        catch (Exception e) {
            LOGGER.error("Unable to add test artifact", (Throwable)e);
        }
    }

    public synchronized Response<TestCaseType> createTestCase(TestCaseType testCase) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + TEST_CASES_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)testCase);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestCaseType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to create test case", (Throwable)e);
        }
        return response;
    }

    public Response<TestCaseType[]> createTestCases(TestCaseType[] testCases) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + TEST_CASES_BATCH_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)testCases);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestCaseType[].class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to create test cases", (Throwable)e);
        }
        return response;
    }

    public Response<TestType[]> getTestRunResults(long id) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(TEST_RUNS_RESULTS_PATH, id));
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestType[].class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to find test run results", (Throwable)e);
        }
        return response;
    }

    private WebResource.Builder initHeaders(WebResource.Builder builder) {
        if (!StringUtils.isEmpty((CharSequence)this.authToken)) {
            builder.header("Authorization", (Object)this.authToken);
        }
        if (!StringUtils.isEmpty((CharSequence)this.project)) {
            builder.header("Project", (Object)this.project);
        }
        return builder;
    }

    public String getProject() {
        return this.project;
    }

    public ZafiraClient initProject(String project) {
        Response<ProjectType> rs;
        if (!StringUtils.isEmpty((CharSequence)project) && (rs = this.getProjectByName(project)).getStatus() == 200) {
            this.project = rs.getObject().getName();
        }
        return this;
    }

    public UserType registerUser(String userName, String email, String firstName, String lastName) {
        if (StringUtils.isEmpty((CharSequence)userName) || userName.equals("$BUILD_USER_ID")) {
            userName = DEFAULT_USER;
        }
        userName = userName.toLowerCase();
        String userDetails = "userName: %s, email: %s, firstName: %s, lastName: %s";
        LOGGER.debug("User details for registration:" + String.format(userDetails, userName, email, firstName, lastName));
        UserType user = new UserType(userName, email, firstName, lastName);
        Response<UserType> response = this.createUser(user);
        user = response.getObject();
        if (user == null) {
            throw new RuntimeException("Unable to register user '" + userName + "' for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered user details:" + String.format(userDetails, user.getUsername(), user.getEmail(), user.getFirstName(), user.getLastName()));
        return user;
    }

    public TestCaseType registerTestCase(Long suiteId, Long primaryOwnerId, Long secondaryOwnerId, String testClass, String testMethod) {
        TestCaseType testCase = new TestCaseType(testClass, testMethod, "", suiteId, primaryOwnerId, secondaryOwnerId);
        String testCaseDetails = "testClass: %s, testMethod: %s, info: %s, testSuiteId: %d, primaryOwnerId: %d, secondaryOwnerId: %d";
        LOGGER.debug("Test Case details for registration:" + String.format(testCaseDetails, testClass, testMethod, "", suiteId, primaryOwnerId, secondaryOwnerId));
        Response<TestCaseType> response = this.createTestCase(testCase);
        testCase = response.getObject();
        if (testCase == null) {
            throw new RuntimeException("Unable to register test case '" + String.format(testCaseDetails, testClass, testMethod, "", suiteId, primaryOwnerId) + "' for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered test case details:" + String.format(testCaseDetails, testClass, testMethod, "", suiteId, primaryOwnerId, secondaryOwnerId));
        return testCase;
    }

    public TestType registerWorkItems(Long testId, List<String> workItems) {
        TestType test = null;
        if (workItems != null && workItems.size() > 0) {
            Response<TestType> response = this.createTestWorkItems(testId, workItems);
            test = response.getObject();
        }
        return test;
    }

    public TestSuiteType registerTestSuite(String suiteName, String fileName, Long userId) {
        TestSuiteType testSuite = new TestSuiteType(suiteName, fileName, userId);
        String testSuiteDetails = "suiteName: %s, fileName: %s, userId: %s";
        LOGGER.debug("Test Suite details for registration:" + String.format(testSuiteDetails, suiteName, fileName, userId));
        Response<TestSuiteType> response = this.createTestSuite(testSuite);
        testSuite = response.getObject();
        if (testSuite == null) {
            throw new RuntimeException("Unable to register test suite '" + suiteName + "' for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered test suite details:" + String.format(testSuiteDetails, testSuite.getName(), testSuite.getFileName(), testSuite.getUserId()));
        return testSuite;
    }

    public JobType registerJob(String jobUrl, Long userId) {
        jobUrl = jobUrl.replaceAll("/$", "");
        String jobName = StringUtils.substringAfterLast((String)jobUrl, (String)"/");
        String jenkinsHost = "";
        if (jobUrl.contains("/view/")) {
            jenkinsHost = jobUrl.split("/view/")[0];
        } else if (jobUrl.contains("/job/")) {
            jenkinsHost = jobUrl.split("/job/")[0];
        }
        String jobDetails = "jobName: %s, jenkinsHost: %s, userId: %s";
        LOGGER.debug("Job details for registration:" + String.format(jobDetails, jobName, jenkinsHost, userId));
        JobType job = new JobType(jobName, jobUrl, jenkinsHost, userId);
        Response<JobType> response = this.createJob(job);
        job = response.getObject();
        if (job == null) {
            throw new RuntimeException("Unable to register job for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered job details:" + String.format(jobDetails, job.getName(), job.getJenkinsHost(), job.getUserId()));
        return job;
    }

    public TestRunType registerTestRunByHUMAN(Long testSuiteId, Long userId, String configXML, Long jobId, CIConfig ciConfig, TestRun.Initiator startedBy, String workItem, TestRun.DriverMode driverMode) {
        TestRunType testRun = new TestRunType(ciConfig.getCiRunId(), testSuiteId, userId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), configXML, jobId, ciConfig.getCiBuild(), startedBy, workItem);
        testRun.setDriverMode(driverMode);
        String testRunDetails = "testSuiteId: %s, userId: %s, scmURL: %s, scmBranch: %s, scmCommit: %s, jobId: %s, buildNumber: %s, startedBy: %s, workItem";
        LOGGER.debug("Test Run details for registration:" + String.format(testRunDetails, testSuiteId, userId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem));
        Response<TestRunType> response = this.startTestRun(testRun);
        testRun = response.getObject();
        if (testRun == null) {
            throw new RuntimeException("Unable to register test run '" + String.format(testRunDetails, testSuiteId, userId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem) + "' for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered test run details:" + String.format(testRunDetails, testSuiteId, userId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem));
        return testRun;
    }

    public TestRunType registerTestRunBySCHEDULER(Long testSuiteId, String configXML, Long jobId, CIConfig ciConfig, TestRun.Initiator startedBy, String workItem, TestRun.DriverMode driverMode) {
        TestRunType testRun = new TestRunType(ciConfig.getCiRunId(), testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), configXML, jobId, ciConfig.getCiBuild(), startedBy, workItem);
        testRun.setDriverMode(driverMode);
        String testRunDetails = "testSuiteId: %s, scmURL: %s, scmBranch: %s, scmCommit: %s, jobId: %s, buildNumber: %s, startedBy: %s, workItem";
        LOGGER.debug("Test Run details for registration:" + String.format(testRunDetails, testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem));
        Response<TestRunType> response = this.startTestRun(testRun);
        testRun = response.getObject();
        if (testRun == null) {
            throw new RuntimeException("Unable to register test run '" + String.format(testRunDetails, testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem) + "' for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered test run details:" + String.format(testRunDetails, testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem));
        return testRun;
    }

    public TestRunType registerTestRunUPSTREAM_JOB(Long testSuiteId, String configXML, Long jobId, Long parentJobId, CIConfig ciConfig, TestRun.Initiator startedBy, String workItem, TestRun.DriverMode driverMode) {
        TestRunType testRun = new TestRunType(ciConfig.getCiRunId(), testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), configXML, jobId, parentJobId, ciConfig.getCiParentBuild(), ciConfig.getCiBuild(), startedBy, workItem);
        testRun.setDriverMode(driverMode);
        String testRunDetails = "testSuiteId: %s, scmURL: %s, scmBranch: %s, scmCommit: %s, jobId: %s, parentJobId: %s, parentBuildNumber: %s, buildNumber: %s, startedBy: %s, workItem";
        LOGGER.debug("Test Run details for registration:" + String.format(testRunDetails, testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, parentJobId, ciConfig.getCiParentBuild(), ciConfig.getCiBuild(), startedBy, workItem));
        Response<TestRunType> response = this.startTestRun(testRun);
        testRun = response.getObject();
        if (testRun == null) {
            throw new RuntimeException("Unable to register test run '" + String.format(testRunDetails, testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, parentJobId, ciConfig.getCiParentBuild(), ciConfig.getCiBuild(), startedBy, workItem) + "' for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered test run details:" + String.format(testRunDetails, testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, parentJobId, ciConfig.getCiParentBuild(), ciConfig.getCiBuild(), startedBy, workItem));
        return testRun;
    }

    public TestRunType registerTestRunResults(TestRunType testRun) {
        this.updateTestRun(testRun);
        Response<TestRunType> response = this.finishTestRun(testRun.getId());
        return response.getObject();
    }

    public TestType registerTestStart(String name, String group, Status status, String testArgs, Long testRunId, Long testCaseId, int retry, String configXML, String[] dependsOnMethods, String ciTestId, Set<TagType> tags) {
        Response<TestType> response;
        Long startTime = new Date().getTime();
        String testDetails = "name: %s, status: %s, testArgs: %s, testRunId: %s, testCaseId: %s, startTime: %s, retry: %d";
        TestType test = new TestType(name, status, testArgs, testRunId, testCaseId, startTime, null, retry, configXML);
        LOGGER.debug("Test details for startup registration:" + String.format(testDetails, name, status, testArgs, testRunId, testCaseId, startTime, retry));
        test.setCiTestId(ciTestId);
        test.setTestGroup(group);
        test.setTags(tags);
        if (dependsOnMethods != null) {
            StringBuilder sb = new StringBuilder();
            for (String method : dependsOnMethods) {
                sb.append(StringUtils.substringAfterLast((String)method, (String)".")).append(" ");
            }
            test.setDependsOnMethods(sb.toString());
        }
        if ((test = (response = this.startTest(test)).getObject()) == null) {
            throw new RuntimeException("Unable to register test '" + String.format(testDetails, name, status, testArgs, testRunId, testCaseId, startTime, retry) + "' startup for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered test startup details:" + String.format(testDetails, name, status, testArgs, testRunId, testCaseId, startTime, retry));
        return test;
    }

    public TestType registerTestRestart(TestType test) {
        String testName = test.getName();
        Response<TestType> response = this.startTest(test);
        if ((test = response.getObject()) == null) {
            throw new RuntimeException("Unable to register test '" + testName + "' restart for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered test restart details:'" + testName + "'; startTime: " + new Date(test.getStartTime()));
        return test;
    }

    public boolean abortTestRun(long id) {
        boolean aborted = false;
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(TEST_RUNS_ABORT_PATH, id));
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            aborted = clientRS.getStatus() == 200;
        }
        catch (Exception e) {
            LOGGER.error("Unable to find test run by id", (Throwable)e);
        }
        return aborted;
    }

    public synchronized Response<List<HashMap<String, String>>> getToolSettings(String tool, boolean decrypt) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(SETTINGS_TOOL_PATH, tool) + "?decrypt=" + decrypt);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(List.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to authorize user", (Throwable)e);
        }
        return response;
    }

    public String uploadFile(File file, Integer expiresIn, String keyPrefix) throws Exception {
        String filePath = null;
        if (this.amazonClient != null && this.tenantType != null) {
            String fileName = RandomStringUtils.randomAlphanumeric((int)20) + "." + FilenameUtils.getExtension((String)file.getName());
            String key = this.tenantType.getTenant() + keyPrefix + fileName;
            try (SdkBufferedInputStream stream = new SdkBufferedInputStream((InputStream)new FileInputStream(file), (int)(file.length() + 100L));){
                String type = Mimetypes.getInstance().getMimetype(file.getName());
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setContentType(type);
                metadata.setContentLength(file.length());
                PutObjectRequest putRequest = new PutObjectRequest(this.amazonS3SessionCredentials.getBucket(), key, (InputStream)stream, metadata);
                this.amazonClient.putObject(putRequest);
                this.amazonClient.setObjectAcl(this.amazonS3SessionCredentials.getBucket(), key, CannedAccessControlList.Private);
                filePath = this.generateAmazonPresignedURL(expiresIn, key).getObject();
            }
            catch (Exception e) {
                LOGGER.error("Can't save file to Amazon S3", (Throwable)e);
            }
        } else {
            throw new Exception("Can't save file to Amazon S3. Verify your credentials or bucket name");
        }
        return filePath;
    }

    protected void initAmazonS3Client() throws Exception {
        this.amazonS3SessionCredentials = this.getAmazonSessionCredentials().getObject();
        if (this.amazonS3SessionCredentials != null) {
            try {
                this.amazonClient = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicSessionCredentials(this.amazonS3SessionCredentials.getAccessKeyId(), this.amazonS3SessionCredentials.getSecretAccessKey(), this.amazonS3SessionCredentials.getSessionToken())))).withRegion(Regions.fromName((String)this.amazonS3SessionCredentials.getRegion()))).build();
                if (!this.amazonClient.doesBucketExistV2(this.amazonS3SessionCredentials.getBucket())) {
                    throw new Exception(String.format("Amazon S3 bucket with name '%s' doesn't exist.", this.amazonS3SessionCredentials.getBucket()));
                }
            }
            catch (Exception e) {
                throw new Exception("Amazon integration is invalid. Verify your credentials or region.", e);
            }
        }
    }

    private Response<SessionCredentials> getAmazonSessionCredentials() {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + AMAZON_SESSION_CREDENTIALS_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(SessionCredentials.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to get AWS session credentials", (Throwable)e);
        }
        return response;
    }

    private Response<String> generateAmazonPresignedURL(Integer expiresIn, String key) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + AMAZON_PRESIGNED_URL_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)new PresignedUrlRequest(expiresIn, key));
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(String.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to get AWS presigned URL", (Throwable)e);
        }
        return response;
    }

    protected void initTenant() throws Exception {
        this.tenantType = this.getTenant().getObject();
    }

    private Response<TenantType> getTenant() {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + TENANT_TYPE_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TenantType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to get tenant", (Throwable)e);
        }
        return response;
    }

    public synchronized UserType getUserOrAnonymousIfNotFound(String username) {
        Response<UserType> response = this.getUserProfile(username);
        if (response.getStatus() != 200) {
            response = this.getUserProfile(DEFAULT_USER);
        }
        return response.getObject();
    }

    public Response<ProjectType> getProjectByName(String name) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(PROJECTS_PATH, name));
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(ProjectType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to get project by name", (Throwable)e);
        }
        return response;
    }

    public class Response<T> {
        private int status;
        private T object;

        public Response(int status, T object) {
            this.status = status;
            this.object = object;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public T getObject() {
            return this.object;
        }

        public void setObject(T object) {
            this.object = object;
        }
    }
}

