/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.client;

import com.qaprosoft.zafira.client.ZafiraClient;
import com.qaprosoft.zafira.models.dto.auth.AuthTokenType;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.tree.MergeCombiner;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.log4j.Logger;

public enum ZafiraSingleton {
    INSTANCE;

    private final Logger LOGGER = Logger.getLogger(ZafiraSingleton.class);
    private final String ZAFIRA_PROPERTIES = "zafira.properties";
    private ZafiraClient zc;
    private Boolean running = false;

    private ZafiraSingleton() {
        try {
            ZafiraClient.Response<AuthTokenType> auth;
            CombinedConfiguration config = new CombinedConfiguration((NodeCombiner)new MergeCombiner());
            config.setThrowExceptionOnMissing(false);
            config.addConfiguration((Configuration)new SystemConfiguration());
            config.addConfiguration((Configuration)new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().properties().setFileName("zafira.properties")}).getConfiguration());
            boolean enabled = config.getBoolean("zafira_enabled", false);
            String url = config.getString("zafira_service_url", "");
            String token = config.getString("zafira_access_token", "");
            this.zc = new ZafiraClient(url);
            if (enabled && this.zc.isAvailable() && (auth = this.zc.refreshToken(token)).getStatus() == 200) {
                this.zc.setAuthToken(auth.getObject().getType() + " " + auth.getObject().getAccessToken());
                this.running = true;
                this.zc.initAmazonS3Client();
                this.zc.initTenant();
            }
        }
        catch (Exception e) {
            this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public ZafiraClient getClient() {
        return this.zc;
    }

    public Boolean isRunning() {
        return this.running;
    }
}

