/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.listener;

import com.qaprosoft.zafira.client.ZafiraClient;
import com.qaprosoft.zafira.config.CIConfig;
import com.qaprosoft.zafira.config.IConfigurator;
import com.qaprosoft.zafira.listener.ExcludeTestsForRerun;
import com.qaprosoft.zafira.models.db.Status;
import com.qaprosoft.zafira.models.db.TestRun;
import com.qaprosoft.zafira.models.dto.JobType;
import com.qaprosoft.zafira.models.dto.TestCaseType;
import com.qaprosoft.zafira.models.dto.TestRunType;
import com.qaprosoft.zafira.models.dto.TestSuiteType;
import com.qaprosoft.zafira.models.dto.TestType;
import com.qaprosoft.zafira.models.dto.auth.AuthTokenType;
import com.qaprosoft.zafira.models.dto.config.ConfigurationType;
import com.qaprosoft.zafira.models.dto.user.UserType;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.MergeCombiner;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.xml.XmlClass;

public class ZafiraListener
implements ISuiteListener,
ITestListener,
IHookable,
IInvokedMethodListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZafiraListener.class);
    private static final String ZAFIRA_PROPERTIES = "zafira.properties";
    private static final String ZAFIRA_PROJECT_PARAM = "zafira_project";
    private static final String ZAFIRA_RUN_ID_PARAM = "zafira_run_id";
    private boolean ZAFIRA_ENABLED = false;
    private String ZAFIRA_URL = null;
    private String ZAFIRA_ACCESS_TOKEN = null;
    private String ZAFIRA_PROJECT = null;
    private boolean ZAFIRA_RERUN_FAILURES = false;
    private String ZAFIRA_CONFIGURATOR = null;
    private String JIRA_SUITE_ID = null;
    private IConfigurator configurator;
    private CIConfig ci;
    private ZafiraClient zc;
    private UserType user = null;
    private JobType parentJob = null;
    private JobType job = null;
    private TestSuiteType suite = null;
    private TestRunType run = null;
    private Map<String, TestType> registeredTests = new HashMap<String, TestType>();
    private Set<String> classesToRerun = new HashSet<String>();
    private static ThreadLocal<String> threadCiTestId = new ThreadLocal();
    private static ThreadLocal<TestType> threadTest = new ThreadLocal();
    private Marshaller marshaller;
    private static final String SKIP_CFG_EXC_MSG = "Skipping configuration method since test class doesn't contain test methods to rerun";

    public void onStart(ISuite suiteContext) {
        boolean initialized = this.initializeZafira(suiteContext);
        if (!initialized) {
            return;
        }
        try {
            ZafiraClient.Response<TestRunType> response;
            this.marshaller = JAXBContext.newInstance((Class[])new Class[]{ConfigurationType.class}).createMarshaller();
            this.configurator = (IConfigurator)Class.forName(this.ZAFIRA_CONFIGURATOR).newInstance();
            String project = suiteContext.getXmlSuite().getParameter(ZAFIRA_PROJECT_PARAM);
            this.zc.initProject(!StringUtils.isEmpty((CharSequence)project) ? project : this.ZAFIRA_PROJECT);
            this.user = this.zc.getUserProfile().getObject();
            UserType suiteOwner = this.zc.getUserOrAnonymousIfNotFound(this.configurator.getOwner(suiteContext));
            this.suite = this.zc.registerTestSuite(suiteContext.getName(), FilenameUtils.getName((String)suiteContext.getXmlSuite().getFileName()), suiteOwner.getId());
            this.job = this.zc.registerJob(this.ci.getCiUrl(), suiteOwner.getId());
            if (CIConfig.BuildCasue.UPSTREAMTRIGGER.equals((Object)this.ci.getCiBuildCause())) {
                UserType anonymous = this.zc.getUserOrAnonymousIfNotFound("anonymous");
                this.parentJob = this.zc.registerJob(this.ci.getCiParentUrl(), anonymous.getId());
            }
            if (!StringUtils.isEmpty((CharSequence)this.ci.getCiRunId())) {
                response = this.zc.getTestRunByCiRunId(this.ci.getCiRunId());
                this.run = response.getObject();
            }
            if (this.run != null) {
                this.run.setBuildNumber(this.ci.getCiBuild());
                this.run.setConfigXML(this.convertToXML(this.configurator.getConfiguration()));
                response = this.zc.startTestRun(this.run);
                this.run = response.getObject();
                List<Object> testRunResults = Arrays.asList((Object[])this.zc.getTestRunResults(this.run.getId()).getObject());
                for (TestType testType : testRunResults) {
                    this.registeredTests.put(testType.getName(), testType);
                    if (!testType.isNeedRerun()) continue;
                    this.classesToRerun.add(testType.getTestClass());
                }
                if (this.ZAFIRA_RERUN_FAILURES) {
                    ExcludeTestsForRerun.excludeTestsForRerun(suiteContext, testRunResults, this.configurator);
                }
            } else {
                if (this.ZAFIRA_RERUN_FAILURES) {
                    LOGGER.error("Unable to find data in Zafira Reporting Service with CI_RUN_ID: '" + this.ci.getCiRunId() + "'.\nRerun failures featrure will be disabled!");
                    this.ZAFIRA_RERUN_FAILURES = false;
                }
                TestRun.DriverMode driverMode = this.configurator.getDriverMode();
                switch (this.ci.getCiBuildCause()) {
                    case UPSTREAMTRIGGER: {
                        this.run = this.zc.registerTestRunUPSTREAM_JOB(this.suite.getId(), this.convertToXML(this.configurator.getConfiguration()), this.job.getId(), this.parentJob.getId(), this.ci, TestRun.Initiator.UPSTREAM_JOB, this.JIRA_SUITE_ID, driverMode);
                        break;
                    }
                    case TIMERTRIGGER: 
                    case SCMTRIGGER: {
                        this.run = this.zc.registerTestRunBySCHEDULER(this.suite.getId(), this.convertToXML(this.configurator.getConfiguration()), this.job.getId(), this.ci, TestRun.Initiator.SCHEDULER, this.JIRA_SUITE_ID, driverMode);
                        break;
                    }
                    case MANUALTRIGGER: {
                        this.run = this.zc.registerTestRunByHUMAN(this.suite.getId(), this.user.getId(), this.convertToXML(this.configurator.getConfiguration()), this.job.getId(), this.ci, TestRun.Initiator.HUMAN, this.JIRA_SUITE_ID, driverMode);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unable to register test run for zafira service: " + this.ZAFIRA_URL + " due to the misses build cause: '" + (Object)((Object)this.ci.getCiBuildCause()) + "'");
                    }
                }
            }
            if (this.run == null) {
                throw new RuntimeException("Unable to register test run for zafira service: " + this.ZAFIRA_URL);
            }
            System.setProperty(ZAFIRA_RUN_ID_PARAM, String.valueOf(this.run.getId()));
            Runtime.getRuntime().addShutdownHook(new TestRunShutdownHook(this.zc, this.run));
        }
        catch (Throwable e) {
            this.ZAFIRA_ENABLED = false;
            LOGGER.error("Undefined error during test run registration!", e);
        }
    }

    public void onTestStart(ITestResult result) {
        if (!this.ZAFIRA_ENABLED) {
            return;
        }
        try {
            TestType startedTest = null;
            String testName = this.configurator.getTestName(result);
            String primaryOwnerName = !StringUtils.isEmpty((CharSequence)this.configurator.getPrimaryOwner(result)) ? this.configurator.getPrimaryOwner(result) : this.configurator.getOwner(result.getTestContext().getSuite());
            UserType primaryOwner = this.zc.getUserOrAnonymousIfNotFound(primaryOwnerName);
            LOGGER.debug("primaryOwner: " + primaryOwnerName);
            String secondaryOwnerName = this.configurator.getSecondaryOwner(result);
            UserType secondaryOwner = null;
            if (!StringUtils.isEmpty((CharSequence)secondaryOwnerName)) {
                secondaryOwner = this.zc.getUserOrAnonymousIfNotFound(secondaryOwnerName);
                LOGGER.debug("secondaryOwner: " + secondaryOwnerName);
            }
            String testClass = result.getMethod().getTestClass().getName();
            String testMethod = this.configurator.getTestMethodName(result);
            TestCaseType testCase = this.zc.registerTestCase(this.suite.getId(), primaryOwner.getId(), secondaryOwner != null ? Long.valueOf(secondaryOwner.getId()) : null, testClass, testMethod);
            if (this.registeredTests.containsKey(testName)) {
                startedTest = this.registeredTests.get(testName);
                if (this.ZAFIRA_RERUN_FAILURES && !startedTest.isNeedRerun()) {
                    throw new SkipException("ALREADY_PASSED: " + testName);
                }
                startedTest.setFinishTime(null);
                startedTest.setStartTime(Long.valueOf(new Date().getTime()));
                startedTest.setCiTestId(ZafiraListener.getThreadCiTestId());
                startedTest.setTags(this.configurator.getTestTags(result));
                startedTest = this.zc.registerTestRestart(startedTest);
            }
            if (startedTest == null) {
                String testArgs = result.getParameters().toString();
                String group = result.getMethod().getTestClass().getName();
                group = group.substring(0, group.lastIndexOf("."));
                String[] dependsOnMethods = result.getMethod().getMethodsDependedUpon();
                startedTest = this.zc.registerTestStart(testName, group, Status.IN_PROGRESS, testArgs, this.run.getId(), testCase.getId(), this.configurator.getRunCount(result), this.convertToXML(this.configurator.getConfiguration()), dependsOnMethods, ZafiraListener.getThreadCiTestId(), this.configurator.getTestTags(result));
            }
            this.zc.registerWorkItems(startedTest.getId(), this.configurator.getTestWorkItems(result));
            threadTest.set(startedTest);
            this.registeredTests.put(testName, startedTest);
            result.setAttribute("ztid", (Object)startedTest.getId());
        }
        catch (SkipException e) {
            throw e;
        }
        catch (Throwable e) {
            LOGGER.error("Undefined error during test case/method start!", e);
        }
    }

    public void onTestSuccess(ITestResult result) {
        if (!this.ZAFIRA_ENABLED) {
            return;
        }
        try {
            ZafiraClient.Response<TestType> rs = this.zc.finishTest(this.populateTestResult(result, Status.PASSED, this.getFullStackTrace(result)));
            if (rs.getStatus() != 200 && rs.getObject() == null) {
                throw new RuntimeException("Unable to register test " + rs.getObject().getName() + " for zafira service: " + this.ZAFIRA_URL);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Undefined error during test case/method finish!", e);
        }
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        if (!this.ZAFIRA_ENABLED) {
            return;
        }
        try {
            ZafiraClient.Response<TestType> rs = this.zc.finishTest(this.populateTestResult(result, Status.FAILED, this.getFullStackTrace(result)));
            if (rs.getStatus() != 200 && rs.getObject() == null) {
                throw new RuntimeException("Unable to register test " + rs.getObject().getName() + " for zafira service: " + this.ZAFIRA_URL);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Undefined error during test case/method finish!", e);
        }
    }

    public void onTestFailure(ITestResult result) {
        if (!this.ZAFIRA_ENABLED) {
            return;
        }
        try {
            ZafiraClient.Response<TestType> rs = this.zc.finishTest(this.populateTestResult(result, Status.FAILED, this.getFullStackTrace(result)));
            if (rs.getStatus() != 200 && rs.getObject() == null) {
                throw new RuntimeException("Unable to register test " + rs.getObject().getName() + " for zafira service: " + this.ZAFIRA_URL);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Undefined error during test case/method finish!", e);
        }
    }

    public void onTestSkipped(ITestResult result) {
        if (!this.ZAFIRA_ENABLED) {
            return;
        }
        if (result.getThrowable() != null && result.getThrowable().getMessage() != null && result.getThrowable().getMessage().startsWith("ALREADY_PASSED")) {
            return;
        }
        try {
            ZafiraClient.Response<TestType> rs;
            TestType test = threadTest.get();
            if (test == null) {
                test = this.registeredTests.get(this.configurator.getTestName(result));
            }
            if (test == null) {
                String testName = this.configurator.getTestName(result);
                String primaryOwnerName = !StringUtils.isEmpty((CharSequence)this.configurator.getPrimaryOwner(result)) ? this.configurator.getPrimaryOwner(result) : this.configurator.getOwner(result.getTestContext().getSuite());
                UserType primaryOwner = this.zc.getUserOrAnonymousIfNotFound(primaryOwnerName);
                LOGGER.debug("primaryOwner: " + primaryOwnerName);
                String secondaryOwnerName = this.configurator.getSecondaryOwner(result);
                UserType secondaryOwner = null;
                if (!StringUtils.isEmpty((CharSequence)secondaryOwnerName)) {
                    secondaryOwner = this.zc.getUserOrAnonymousIfNotFound(secondaryOwnerName);
                    LOGGER.debug("secondaryOwner: " + secondaryOwnerName);
                }
                String testClass = result.getMethod().getTestClass().getName();
                String testMethod = this.configurator.getTestMethodName(result);
                TestCaseType testCase = this.zc.registerTestCase(this.suite.getId(), primaryOwner.getId(), secondaryOwner != null ? Long.valueOf(secondaryOwner.getId()) : null, testClass, testMethod);
                String testArgs = result.getParameters().toString();
                String group = result.getMethod().getTestClass().getName();
                group = group.substring(0, group.lastIndexOf("."));
                String[] dependsOnMethods = result.getMethod().getMethodsDependedUpon();
                test = this.zc.registerTestStart(testName, group, Status.SKIPPED, testArgs, this.run.getId(), testCase.getId(), this.configurator.getRunCount(result), this.convertToXML(this.configurator.getConfiguration()), dependsOnMethods, ZafiraListener.getThreadCiTestId(), this.configurator.getTestTags(result));
                threadTest.set(test);
            }
            if ((rs = this.zc.finishTest(this.populateTestResult(result, Status.SKIPPED, this.getFullStackTrace(result)))).getStatus() != 200 && rs.getObject() == null) {
                throw new RuntimeException("Unable to register test " + rs.getObject().getName() + " for zafira service: " + this.ZAFIRA_URL);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Undefined error during test case/method finish!", e);
        }
    }

    private TestType populateTestResult(ITestResult result, Status status, String message) throws JAXBException {
        long threadId = Thread.currentThread().getId();
        TestType test = threadTest.get();
        Long finishTime = new Date().getTime();
        String testName = this.configurator.getTestName(result);
        LOGGER.debug("testName registered with current thread is: " + testName);
        if (test == null) {
            throw new RuntimeException("Unable to find TestType result to mark test as finished! name: '" + testName + "'; threadId: " + threadId);
        }
        test.setTestMetrics(this.configurator.getTestMetrics(result));
        test.setConfigXML(this.convertToXML(this.configurator.getConfiguration()));
        test.setArtifacts(this.configurator.getArtifacts(result));
        String testDetails = "testId: %d; testCaseId: %d; testRunId: %d; name: %s; thread: %s; status: %s, finishTime: %s \n message: %s";
        String logMessage = String.format(testDetails, test.getId(), test.getTestCaseId(), test.getTestRunId(), test.getName(), threadId, status, finishTime, message);
        LOGGER.debug("Test details to finish registration:" + logMessage);
        test.setStatus(status);
        test.setMessage(message);
        test.setFinishTime(finishTime);
        threadTest.remove();
        threadCiTestId.remove();
        return test;
    }

    public void onFinish(ISuite suiteContext) {
        if (!this.ZAFIRA_ENABLED) {
            return;
        }
        try {
            this.run.setConfigXML(this.convertToXML(this.configurator.getConfiguration()));
            this.zc.registerTestRunResults(this.run);
        }
        catch (Throwable e) {
            LOGGER.error("Unable to finish test run correctly", e);
        }
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }

    public void run(IHookCallBack hookCallBack, ITestResult testResult) {
        if (!this.ZAFIRA_ENABLED) {
            hookCallBack.runTestMethod(testResult);
        } else {
            String testName = this.configurator.getTestName(testResult);
            TestType startedTest = this.registeredTests.get(testName);
            if (!this.ZAFIRA_RERUN_FAILURES || startedTest == null || startedTest.isNeedRerun()) {
                hookCallBack.runTestMethod(testResult);
            }
        }
    }

    public void beforeInvocation(IInvokedMethod invokedMethod, ITestResult testResult) {
        if (this.ZAFIRA_RERUN_FAILURES) {
            ITestNGMethod m = invokedMethod.getTestMethod();
            String declaringClassName = m.getConstructorOrMethod().getMethod().getDeclaringClass().getName();
            String testClassName = m.getTestClass().getName();
            if (!this.classesToRerun.contains(testClassName) && declaringClassName.equals(testClassName)) {
                if (m.isBeforeClassConfiguration() || m.isAfterClassConfiguration()) {
                    LOGGER.info("SKIPPING CONFIGURATION METHOD: " + declaringClassName + " : " + m.getMethodName() + " for class " + testClassName);
                    throw new SkipException(SKIP_CFG_EXC_MSG);
                }
                if (m.isBeforeTestConfiguration() || m.isAfterTestConfiguration()) {
                    boolean shouldSkip = true;
                    for (XmlClass cl : testResult.getTestContext().getCurrentXmlTest().getClasses()) {
                        if (!this.classesToRerun.contains(cl.getName())) continue;
                        shouldSkip = false;
                        break;
                    }
                    if (shouldSkip) {
                        LOGGER.info("SKIPPING CONFIGURATION METHOD: " + declaringClassName + " : " + m.getMethodName() + " for class " + testClassName);
                        throw new SkipException(SKIP_CFG_EXC_MSG);
                    }
                }
            }
        }
    }

    public void afterInvocation(IInvokedMethod invokedMethod, ITestResult testResult) {
    }

    private boolean initializeZafira(ISuite suiteContext) {
        boolean success = false;
        try {
            CombinedConfiguration config = new CombinedConfiguration((NodeCombiner)new MergeCombiner());
            config.setThrowExceptionOnMissing(true);
            config.addConfiguration((Configuration)new SystemConfiguration());
            config.addConfiguration((Configuration)new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().properties().setFileName(ZAFIRA_PROPERTIES)}).getConfiguration());
            this.ci = new CIConfig();
            this.ci.setCiRunId(config.getString("ci_run_id", UUID.randomUUID().toString()));
            this.ci.setCiUrl(config.getString("ci_url", "http://localhost:8080/job/unavailable"));
            this.ci.setCiBuild(config.getString("ci_build", null));
            this.ci.setCiBuildCause(config.getString("ci_build_cause", "MANUALTRIGGER"));
            this.ci.setCiParentUrl(config.getString("ci_parent_url", null));
            this.ci.setCiParentBuild(config.getString("ci_parent_build", null));
            this.ci.setGitBranch(config.getString("git_branch", null));
            this.ci.setGitCommit(config.getString("git_commit", null));
            this.ci.setGitUrl(config.getString("git_url", null));
            this.JIRA_SUITE_ID = config.getString("jira_suite_id", null);
            this.ZAFIRA_ENABLED = (Boolean)ZafiraConfiguration.ENABLED.get((Configuration)config, suiteContext);
            this.ZAFIRA_URL = (String)ZafiraConfiguration.SERVICE_URL.get((Configuration)config, suiteContext);
            this.ZAFIRA_ACCESS_TOKEN = (String)ZafiraConfiguration.ACCESS_TOKEN.get((Configuration)config, suiteContext);
            this.ZAFIRA_PROJECT = (String)ZafiraConfiguration.PROJECT.get((Configuration)config, suiteContext);
            this.ZAFIRA_RERUN_FAILURES = (Boolean)ZafiraConfiguration.RERUN_FAILURES.get((Configuration)config, suiteContext);
            this.ZAFIRA_CONFIGURATOR = (String)ZafiraConfiguration.CONFIGURATOR.get((Configuration)config, suiteContext);
            if (this.ZAFIRA_ENABLED) {
                this.zc = new ZafiraClient(this.ZAFIRA_URL);
                this.ZAFIRA_ENABLED = this.zc.isAvailable();
                if (this.ZAFIRA_ENABLED) {
                    ZafiraClient.Response<AuthTokenType> auth = this.zc.refreshToken(this.ZAFIRA_ACCESS_TOKEN);
                    if (auth.getStatus() == 200) {
                        this.zc.setAuthToken(auth.getObject().getType() + " " + auth.getObject().getAccessToken());
                    } else {
                        this.ZAFIRA_ENABLED = false;
                    }
                }
                LOGGER.info("Zafira is " + (this.ZAFIRA_ENABLED ? "available" : "unavailable"));
            }
            success = this.ZAFIRA_ENABLED;
        }
        catch (ConfigurationException e) {
            LOGGER.error("Unable to locate zafira.properties: ", (Throwable)e);
        }
        catch (NoSuchElementException e) {
            LOGGER.error("Unable to find config property: ", (Throwable)e);
        }
        return success;
    }

    private String convertToXML(ConfigurationType config) {
        StringWriter w = new StringWriter();
        try {
            this.marshaller.marshal((Object)(config != null ? config : new ConfigurationType()), (Writer)w);
        }
        catch (Throwable thr) {
            LOGGER.error("Unable to convert config to XML!", thr);
        }
        return w.toString();
    }

    private String getFullStackTrace(ITestResult result) {
        StringBuilder sb;
        block6: {
            StackTraceElement[] elems;
            block5: {
                int i;
                sb = new StringBuilder();
                if (result.getThrowable() != null) break block5;
                if (result.getStatus() != 3) break block6;
                String[] methods = result.getMethod().getMethodsDependedUpon();
                boolean dependentMethod = false;
                String dependentMethodName = "";
                block0: for (ITestResult failedTest : result.getTestContext().getFailedTests().getAllResults()) {
                    for (i = 0; i < methods.length; ++i) {
                        if (!methods[i].contains(failedTest.getName())) continue;
                        dependentMethodName = failedTest.getName();
                        dependentMethod = true;
                        continue block0;
                    }
                }
                block2: for (ITestResult skippedTest : result.getTestContext().getSkippedTests().getAllResults()) {
                    for (i = 0; i < methods.length; ++i) {
                        if (!methods[i].contains(skippedTest.getName())) continue;
                        dependentMethodName = skippedTest.getName();
                        dependentMethod = true;
                        continue block2;
                    }
                }
                if (!dependentMethod) break block6;
                sb.append("Test skipped due to the dependency from: ").append(dependentMethodName);
                break block6;
            }
            sb.append(result.getThrowable().getMessage()).append("\n");
            for (StackTraceElement elem : elems = result.getThrowable().getStackTrace()) {
                sb.append("\n").append(elem.toString());
            }
        }
        return !StringUtils.isEmpty((CharSequence)sb.toString()) ? sb.toString() : null;
    }

    public static String getThreadCiTestId() {
        if (StringUtils.isEmpty((CharSequence)threadCiTestId.get())) {
            threadCiTestId.set(UUID.randomUUID().toString());
        }
        return threadCiTestId.get();
    }

    public static enum ZafiraConfiguration {
        ENABLED("zafira_enabled", false),
        SERVICE_URL("zafira_service_url", ""),
        ACCESS_TOKEN("zafira_access_token", ""),
        PROJECT("zafira_project", "", true),
        RERUN_FAILURES("zafira_rerun_failures", false),
        CONFIGURATOR("zafira_configurator", "com.qaprosoft.zafira.listener.DefaultConfigurator", true);

        private String configName;
        private Object defaultValue;
        private boolean canOverride;

        private ZafiraConfiguration(String configName, Object defaultValue) {
            this.configName = configName;
            this.defaultValue = defaultValue;
        }

        private ZafiraConfiguration(String configName, Object defaultValue, boolean canOverride) {
            this.configName = configName;
            this.defaultValue = defaultValue;
            this.canOverride = canOverride;
        }

        public String getConfigName() {
            return this.configName;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isCanOverride() {
            return this.canOverride;
        }

        public Object get(Configuration config, ISuite suiteConfig) {
            return this.canOverride && suiteConfig.getParameter(this.configName) != null ? suiteConfig.getParameter(this.configName) : config.get(this.getDefaultClassValue(), this.configName, this.defaultValue);
        }

        private Class getDefaultClassValue() {
            Class aClass = null;
            if (this.defaultValue instanceof String) {
                aClass = String.class;
            } else if (this.defaultValue instanceof Boolean) {
                aClass = Boolean.class;
            } else if (this.defaultValue instanceof Integer) {
                aClass = Integer.class;
            }
            return aClass;
        }
    }

    public static class TestRunShutdownHook
    extends Thread {
        private ZafiraClient zc;
        private TestRunType testRun;

        public TestRunShutdownHook(ZafiraClient zc, TestRunType testRun) {
            this.zc = zc;
            this.testRun = testRun;
        }

        @Override
        public void run() {
            if (this.testRun != null) {
                boolean aborted = this.zc.abortTestRun(this.testRun.getId());
                LOGGER.info("TestRunShutdownHook was executed with result: " + aborted);
            }
        }
    }
}

