/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.log;

import com.qaprosoft.zafira.log.MetaInfoLevel;
import com.qaprosoft.zafira.log.MetaInfoMessage;
import java.util.ArrayList;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JSONLayout
extends Layout {
    public String format(LoggingEvent loggingEvent) {
        JSONObject root = new JSONObject();
        try {
            this.writeBasic(root, loggingEvent);
            this.writeThrowable(root, loggingEvent);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return root.toString();
    }

    protected void writeThrowable(JSONObject json, LoggingEvent event) throws JSONException {
        ThrowableInformation ti = event.getThrowableInformation();
        if (ti != null) {
            Throwable t = ti.getThrowable();
            JSONObject throwable = new JSONObject();
            throwable.put("message", (Object)t.getMessage());
            throwable.put("className", (Object)t.getClass().getCanonicalName());
            ArrayList<JSONObject> traceObjects = new ArrayList<JSONObject>();
            for (StackTraceElement ste : t.getStackTrace()) {
                JSONObject element = new JSONObject();
                element.put("class", (Object)ste.getClassName());
                element.put("method", (Object)ste.getMethodName());
                element.put("line", ste.getLineNumber());
                element.put("file", (Object)ste.getFileName());
                traceObjects.add(element);
            }
            json.put("stackTrace", traceObjects);
            json.put("throwable", (Object)throwable);
        }
    }

    protected void writeBasic(JSONObject json, LoggingEvent event) throws JSONException {
        json.put("threadName", (Object)event.getThreadName());
        json.put("level", (Object)event.getLevel().toString());
        json.put("timestamp", System.currentTimeMillis());
        if (event.getLevel().equals((Object)MetaInfoLevel.META_INFO)) {
            MetaInfoMessage metaInfoMessage = (MetaInfoMessage)event.getMessage();
            json.put("message", (Object)metaInfoMessage.getMessage());
            json.put("headers", (Object)new JSONObject(metaInfoMessage.getHeaders()));
        } else {
            json.put("message", event.getMessage());
        }
        json.put("logger", (Object)event.getLoggerName());
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void activateOptions() {
    }
}

