/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.log;

import com.qaprosoft.zafira.client.ZafiraClient;
import com.qaprosoft.zafira.client.ZafiraSingleton;
import com.qaprosoft.zafira.listener.ZafiraListener;
import com.qaprosoft.zafira.log.MetaInfoLevel;
import com.qaprosoft.zafira.log.MetaInfoMessage;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.tree.MergeCombiner;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class ZafiraLogAppender
extends AppenderSkeleton {
    private static final String ZAFIRA_PROPERTIES = "zafira.properties";
    private ConnectionFactory factory = new ConnectionFactory();
    private Connection connection = null;
    private Channel channel = null;
    private String identifier = null;
    private String host = "localhost";
    private int port = 5672;
    private String username = "guest";
    private String password = "guest";
    private String virtualHost = "/";
    private String exchange = "logs";
    private String type = "x-recent-history";
    private boolean durable = false;
    private String routingKey = "";
    private boolean zafiraConnected = false;
    private int history = 1000;
    private ExecutorService threadPool = Executors.newCachedThreadPool();

    protected void append(LoggingEvent loggingEvent) {
        if (this.isAsSevereAsThreshold((Priority)loggingEvent.getLevel())) {
            this.threadPool.submit(new AppenderTask(loggingEvent));
        }
    }

    public void activateOptions() {
        super.activateOptions();
        this.zafiraConnected = this.connectZafira();
        if (this.zafiraConnected) {
            try {
                this.createConnection();
            }
            catch (Exception e) {
                this.errorHandler.error("Unable to create RabbitMQ connection: " + e.getMessage());
            }
            try {
                this.createChannel();
            }
            catch (Exception e) {
                this.errorHandler.error("Unable to create RabbitMQ channel: " + e.getMessage());
            }
            try {
                this.createExchange();
            }
            catch (Exception e) {
                this.errorHandler.error("Unable to create RabbitMQ exchange: " + e.getMessage());
            }
        }
    }

    private void setFactoryConfiguration() {
        this.factory.setHost(this.host);
        this.factory.setPort(this.port);
        this.factory.setVirtualHost(this.virtualHost);
        this.factory.setUsername(this.username);
        this.factory.setPassword(this.password);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public int getHistory() {
        return this.history;
    }

    public void setHistory(int history) {
        this.history = history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExchange() throws IOException {
        if (this.channel != null && this.channel.isOpen()) {
            Channel channel = this.channel;
            synchronized (channel) {
                HashMap<String, Integer> args = new HashMap<String, Integer>();
                args.put(this.type, this.history);
                this.channel.exchangeDeclare(this.exchange, "x-recent-history", false, false, args);
            }
        }
    }

    private Channel createChannel() throws IOException {
        if (this.channel == null || !this.channel.isOpen() && this.connection != null && this.connection.isOpen()) {
            this.channel = this.connection.createChannel();
        }
        return this.channel;
    }

    private Connection createConnection() throws IOException, TimeoutException {
        this.setFactoryConfiguration();
        if (this.connection == null || !this.connection.isOpen()) {
            this.connection = this.factory.newConnection();
        }
        return this.connection;
    }

    private boolean connectZafira() {
        boolean connected = false;
        try {
            CombinedConfiguration config = new CombinedConfiguration((NodeCombiner)new MergeCombiner());
            config.setThrowExceptionOnMissing(true);
            config.addConfiguration((Configuration)new SystemConfiguration());
            config.addConfiguration((Configuration)new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().properties().setFileName(ZAFIRA_PROPERTIES)}).getConfiguration());
            if (ZafiraSingleton.INSTANCE.isRunning().booleanValue()) {
                List<HashMap<String, String>> settings;
                ZafiraClient.Response<List<HashMap<String, String>>> rs;
                this.routingKey = config.getString("ci_run_id", null);
                if (StringUtils.isEmpty((CharSequence)this.routingKey)) {
                    this.routingKey = UUID.randomUUID().toString();
                    System.setProperty("ci_run_id", this.routingKey);
                }
                if ((rs = ZafiraSingleton.INSTANCE.getClient().getToolSettings("RABBITMQ", true)).getStatus() == 200 && (settings = rs.getObject()) != null) {
                    for (HashMap<String, String> s : settings) {
                        if ("RABBITMQ_HOST".equals(s.get("name"))) {
                            this.host = s.get("value");
                            continue;
                        }
                        if ("RABBITMQ_PORT".equals(s.get("name"))) {
                            this.port = Integer.valueOf(s.get("value"));
                            continue;
                        }
                        if ("RABBITMQ_USER".equals(s.get("name"))) {
                            this.username = s.get("value");
                            continue;
                        }
                        if ("RABBITMQ_PASSWORD".equals(s.get("name"))) {
                            this.password = s.get("value");
                            continue;
                        }
                        if (!"RABBITMQ_ENABLED".equals(s.get("name"))) continue;
                        connected = Boolean.valueOf(s.get("value"));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return connected;
    }

    public void close() {
        if (this.channel != null && this.channel.isOpen()) {
            try {
                this.channel.close();
            }
            catch (IOException | TimeoutException ioe) {
                this.errorHandler.error(ioe.getMessage(), ioe, 3);
            }
        }
        if (this.connection != null && this.connection.isOpen()) {
            try {
                this.connection.close();
            }
            catch (IOException ioe) {
                this.errorHandler.error(ioe.getMessage(), (Exception)ioe, 3);
            }
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    class AppenderTask
    implements Callable<LoggingEvent> {
        String correlationId;
        LoggingEvent loggingEvent;

        AppenderTask(LoggingEvent loggingEvent) {
            this.loggingEvent = loggingEvent;
            String testId = loggingEvent.getLevel().equals((Object)MetaInfoLevel.META_INFO) && ((MetaInfoMessage)loggingEvent.getMessage()).getHeaders().get("CI_TEST_ID") != null ? ((MetaInfoMessage)loggingEvent.getMessage()).getHeaders().get("CI_TEST_ID") : ZafiraListener.getThreadCiTestId();
            this.correlationId = testId != null ? ZafiraLogAppender.this.routingKey + "_" + String.valueOf(testId) : ZafiraLogAppender.this.routingKey;
        }

        @Override
        public LoggingEvent call() throws Exception {
            if (ZafiraLogAppender.this.zafiraConnected) {
                String payload = ZafiraLogAppender.this.layout.format(this.loggingEvent);
                AMQP.BasicProperties.Builder b = new AMQP.BasicProperties().builder();
                b.appId(ZafiraLogAppender.this.identifier).type(this.loggingEvent.getLevel().toString()).correlationId(String.valueOf(this.correlationId)).contentType("text/json");
                ZafiraLogAppender.this.createChannel().basicPublish(ZafiraLogAppender.this.exchange, ZafiraLogAppender.this.routingKey, b.build(), payload.getBytes());
            }
            return this.loggingEvent;
        }
    }
}

