/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.client;

public enum Path {
    STATUS_PATH("/api/status"),
    PROFILE_PATH("/api/users/profile"),
    LOGIN_PATH("/api/auth/login"),
    ACCESS_PATH("/api/auth/access"),
    REFRESH_TOKEN_PATH("/api/auth/refresh"),
    USERS_PATH("/api/users"),
    JOBS_PATH("/api/jobs"),
    TESTS_PATH("/api/tests"),
    TEST_FINISH_PATH("/api/tests/%d/finish"),
    TEST_BY_ID_PATH("/api/tests/%d"),
    TEST_WORK_ITEMS_PATH("/api/tests/%d/workitems"),
    TEST_WORK_ITEM_PATH("/api/tests/%d/workitem"),
    TEST_ARTIFACTS_PATH("/api/tests/%d/artifacts"),
    TEST_SUITES_PATH("/api/tests/suites"),
    TEST_CASES_PATH("/api/tests/cases"),
    TEST_CASES_BATCH_PATH("/api/tests/cases/batch"),
    TEST_RUNS_PATH("/api/tests/runs"),
    TEST_RUNS_FINISH_PATH("/api/tests/runs/%d/finish"),
    TEST_RUNS_RESULTS_PATH("/api/tests/runs/%d/results"),
    TEST_RUNS_ABORT_PATH("/api/tests/runs/abort"),
    TEST_RUN_BY_ID_PATH("/api/tests/runs/%d"),
    SETTINGS_TOOL_PATH("/api/settings/tool/%s"),
    AMAZON_SESSION_CREDENTIALS_PATH("/api/settings/amazon/creds"),
    TENANT_TYPE_PATH("/api/auth/tenant"),
    PROJECTS_PATH("/api/projects/%s");

    private final String relativePath;

    private Path(String relativePath) {
        this.relativePath = relativePath;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String build(String serviceUrl, Object ... parameters) {
        return serviceUrl + String.format(this.relativePath, parameters);
    }
}

