/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.client.impl;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.internal.SdkBufferedInputStream;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.qaprosoft.zafira.client.BasicClient;
import com.qaprosoft.zafira.client.IntegrationClient;
import com.qaprosoft.zafira.client.Path;
import com.qaprosoft.zafira.models.dto.auth.TenantType;
import com.qaprosoft.zafira.models.dto.aws.SessionCredentials;
import com.qaprosoft.zafira.util.AsyncUtil;
import com.qaprosoft.zafira.util.http.HttpClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationClientImpl
implements IntegrationClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrationClientImpl.class);
    private static final String ERR_MSG_GET_AWS_CREDENTIALS = "Unable to get AWS session credentials";
    private final BasicClient client;
    private CompletableFuture<AmazonS3> amazonClient;
    private SessionCredentials amazonS3SessionCredentials;

    public IntegrationClientImpl(BasicClient client) {
        this.client = client;
    }

    @Override
    public String uploadFile(File file, Integer expiresIn, String keyPrefix) throws Exception {
        String filePath = null;
        TenantType tenantType = this.client.getTenantType();
        if (this.getAmazonClient() != null && tenantType != null && !StringUtils.isBlank((CharSequence)tenantType.getTenant())) {
            String fileName = RandomStringUtils.randomAlphanumeric((int)20) + "." + FilenameUtils.getExtension((String)file.getName());
            String relativeKey = keyPrefix + fileName;
            String key = tenantType.getTenant() + relativeKey;
            try (SdkBufferedInputStream stream = new SdkBufferedInputStream((InputStream)new FileInputStream(file), (int)(file.length() + 100L));){
                String type = Mimetypes.getInstance().getMimetype(file.getName());
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setContentType(type);
                metadata.setContentLength(file.length());
                PutObjectRequest putRequest = new PutObjectRequest(this.amazonS3SessionCredentials.getBucket(), key, (InputStream)stream, metadata);
                this.getAmazonClient().putObject(putRequest);
                CannedAccessControlList controlList = tenantType.isUseArtifactsProxy() ? CannedAccessControlList.Private : CannedAccessControlList.PublicRead;
                this.getAmazonClient().setObjectAcl(this.amazonS3SessionCredentials.getBucket(), key, controlList);
                filePath = tenantType.isUseArtifactsProxy() ? this.client.getRealServiceUrl() + relativeKey : this.getFilePath(key);
            }
            catch (Exception e) {
                LOGGER.error("Can't save file to Amazon S3", (Throwable)e);
            }
        } else {
            throw new Exception("Can't save file to Amazon S3. Verify your credentials or bucket name");
        }
        return filePath;
    }

    private String getFilePath(String key) {
        return this.getAmazonClient().getUrl(this.amazonS3SessionCredentials.getBucket(), key).toString();
    }

    private CompletableFuture<AmazonS3> initAmazonS3Client() {
        this.amazonClient = CompletableFuture.supplyAsync(() -> {
            this.amazonS3SessionCredentials = this.getAmazonSessionCredentials().getObject();
            AmazonS3 client = null;
            if (this.amazonS3SessionCredentials != null) {
                try {
                    client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicSessionCredentials(this.amazonS3SessionCredentials.getAccessKeyId(), this.amazonS3SessionCredentials.getSecretAccessKey(), this.amazonS3SessionCredentials.getSessionToken())))).withRegion(Regions.fromName((String)this.amazonS3SessionCredentials.getRegion()))).build();
                    if (!client.doesBucketExistV2(this.amazonS3SessionCredentials.getBucket())) {
                        throw new Exception(String.format("Amazon S3 bucket with name '%s' doesn't exist.", this.amazonS3SessionCredentials.getBucket()));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Amazon integration is invalid. Verify your credentials or region.", (Throwable)e);
                }
            }
            return client;
        });
        return this.amazonClient;
    }

    private HttpClient.Response<SessionCredentials> getAmazonSessionCredentials() {
        return HttpClient.uri(Path.AMAZON_SESSION_CREDENTIALS_PATH, this.client.getServiceUrl(), new Object[0]).withAuthorization(this.client.getAuthToken()).onFailure(ERR_MSG_GET_AWS_CREDENTIALS).get(SessionCredentials.class);
    }

    private AmazonS3 getAmazonClient() {
        return AsyncUtil.get(this.amazonClient, this::initAmazonS3Client);
    }
}

