/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.listener.adapter.impl;

import com.qaprosoft.zafira.listener.adapter.MethodAdapter;
import com.qaprosoft.zafira.listener.adapter.SuiteAdapter;
import com.qaprosoft.zafira.listener.adapter.TestResultAdapter;
import com.qaprosoft.zafira.listener.adapter.TestResultStatus;
import com.qaprosoft.zafira.listener.adapter.impl.MethodAdapterImpl;
import com.qaprosoft.zafira.listener.adapter.impl.SuiteAdapterImpl;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.internal.TestResult;
import org.testng.xml.XmlClass;

public class TestResultAdapterImpl
implements TestResultAdapter {
    private static final String ERR_MSG_TEST_RESULT_REQUIRED = "TestNG test result is required to apply its data";
    private final ITestResult testResult;

    public TestResultAdapterImpl(ITestResult testResult) {
        this.testResult = testResult;
    }

    public TestResultAdapterImpl(MethodAdapter adapter) {
        TestResult instance = null;
        if (adapter != null) {
            ITestNGMethod method = (ITestNGMethod)adapter.getMethod();
            instance = TestResult.newTestResultFor((ITestNGMethod)method);
        }
        this.testResult = instance;
    }

    public ITestResult getTestResult() {
        this.testResultNotNull();
        return this.testResult;
    }

    @Override
    public String getName() {
        this.testResultNotNull();
        return this.testResult.getName();
    }

    @Override
    public Object[] getParameters() {
        this.testResultNotNull();
        return this.testResult.getParameters();
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.testResultNotNull();
        this.testResult.setAttribute(name, value);
    }

    @Override
    public Throwable getThrowable() {
        this.testResultNotNull();
        return this.testResult.getThrowable();
    }

    @Override
    public TestResultStatus getStatus() {
        this.testResultNotNull();
        return Arrays.stream(TestResultStatus.values()).filter(testResultStatus -> testResultStatus.getCode() == this.testResult.getStatus()).findFirst().orElse(TestResultStatus.UNKNOWN);
    }

    @Override
    public Set<TestResultAdapter> getFailedTestResults() {
        this.testResultNotNull();
        return this.testResult.getTestContext().getFailedTests().getAllResults().stream().map(TestResultAdapterImpl::new).collect(Collectors.toSet());
    }

    @Override
    public Set<TestResultAdapter> getSkippedTestResults() {
        this.testResultNotNull();
        return this.testResult.getTestContext().getSkippedTests().getAllResults().stream().map(TestResultAdapterImpl::new).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getKnownClassNames() {
        this.testResultNotNull();
        return this.testResult.getTestContext().getCurrentXmlTest().getClasses().stream().map(XmlClass::getName).collect(Collectors.toSet());
    }

    @Override
    public RuntimeException getSkipExceptionInstance(String message) {
        return new SkipException(message);
    }

    @Override
    public MethodAdapter getMethodAdapter() {
        this.testResultNotNull();
        return new MethodAdapterImpl(this.testResult.getMethod());
    }

    @Override
    public SuiteAdapter getSuiteAdapter() {
        this.testResultNotNull();
        return new SuiteAdapterImpl(this.testResult.getTestContext().getSuite());
    }

    private void testResultNotNull() {
        if (this.testResult == null) {
            throw new RuntimeException(ERR_MSG_TEST_RESULT_REQUIRED);
        }
    }
}

