/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.listener.service.impl;

import com.qaprosoft.zafira.client.ZafiraClient;
import com.qaprosoft.zafira.listener.service.TestTypeService;
import com.qaprosoft.zafira.models.db.Status;
import com.qaprosoft.zafira.models.db.workitem.WorkItem;
import com.qaprosoft.zafira.models.dto.TagType;
import com.qaprosoft.zafira.models.dto.TestType;
import com.qaprosoft.zafira.util.http.HttpClient;
import java.util.List;
import java.util.Set;

public class TestTypeServiceImpl
implements TestTypeService {
    private final ZafiraClient zafiraClient;

    public TestTypeServiceImpl(ZafiraClient zafiraClient) {
        this.zafiraClient = zafiraClient;
    }

    @Override
    public TestType registerTestRestart(TestType test) {
        return this.zafiraClient.registerTestRestart(test);
    }

    @Override
    public TestType registerTestStart(String testName, String group, Status status, String testArgs, long testRunId, long testCaseId, int runCount, String xmlConfiguration, String[] dependsOnMethods, String testCiId, Set<TagType> tags) {
        return this.zafiraClient.registerTestStart(testName, group, status, testArgs, testRunId, testCaseId, runCount, xmlConfiguration, dependsOnMethods, testCiId, tags);
    }

    @Override
    public TestType registerWorkItems(long testId, List<String> workItems) {
        return this.zafiraClient.registerWorkItems(testId, workItems);
    }

    @Override
    public WorkItem registerKnownIssue(long testId, WorkItem knownIssue) {
        HttpClient.Response<WorkItem> result = this.zafiraClient.createOrUpdateTestWorkItem(testId, knownIssue);
        if (result.getStatus() != 200 && result.getObject() == null) {
            throw new RuntimeException("Unable to register known issue " + knownIssue.getJiraId() + " for zafira service: " + this.zafiraClient.getServiceUrl());
        }
        return result.getObject();
    }

    @Override
    public TestType finishTest(TestType test) {
        HttpClient.Response<TestType> result = this.zafiraClient.finishTest(test);
        if (result.getStatus() != 200 && result.getObject() == null) {
            throw new RuntimeException("Unable to register test " + test.getName() + " for zafira service: " + this.zafiraClient.getServiceUrl());
        }
        return result.getObject();
    }
}

