/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.log;

import com.qaprosoft.zafira.log.event.EventPublisher;
import java.util.concurrent.Callable;

public abstract class BaseAppenderTask<T>
implements Callable<T> {
    private EventPublisher eventPublisher;
    private String routingKey;
    private String identifier;
    private boolean zafiraConnected;
    private String correlationId;

    protected abstract String getTestId();

    protected abstract String getJsonPayload();

    protected abstract String getEventType();

    protected abstract T getEventObject();

    @Override
    public T call() throws Exception {
        this.publishEvent();
        return this.getEventObject();
    }

    private void publishEvent() {
        if (this.zafiraConnected) {
            String payload = this.getJsonPayload();
            String correlationId = this.getCorrelationId();
            this.eventPublisher.publishEvent(this.routingKey, correlationId, this.identifier, this.getEventType(), payload);
        }
    }

    private String buildCorrelationId(String routingKey) {
        String testId = this.getTestId();
        return testId != null ? routingKey + "_" + testId : routingKey;
    }

    private void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    private String getCorrelationId() {
        return this.correlationId;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
        String correlationId = this.buildCorrelationId(routingKey);
        this.setCorrelationId(correlationId);
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setZafiraConnected(boolean zafiraConnected) {
        this.zafiraConnected = zafiraConnected;
    }
}

