/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.log.event.impl;

import com.qaprosoft.zafira.client.BasicClient;
import com.qaprosoft.zafira.log.event.AmqpService;
import com.qaprosoft.zafira.log.event.EventPublisher;
import com.qaprosoft.zafira.util.http.HttpClient;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQService
implements AmqpService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMQService.class);
    private static final String VIRTUAL_HOST = "/";
    private static final String TYPE = "x-recent-history";
    private static final String EXCHANGE_NAME = "logs";
    private static final int HISTORY = 1000;
    private final BasicClient client;
    private ConnectionFactory factory;
    private Connection connection = null;
    private Channel channel = null;
    private String host;
    private int port;
    private String username;
    private String password;
    private boolean connected;

    public RabbitMQService(BasicClient client) {
        this.client = client;
        this.host = "localhost";
        this.port = 5672;
        this.username = "guest";
        this.password = "guest";
    }

    @Override
    public synchronized EventPublisher connect() throws IOException, TimeoutException {
        boolean isRabbitMQEnabled = this.initAuthProperties();
        if (isRabbitMQEnabled) {
            this.factory = this.createConnectionFactory();
            this.connection = this.createConnection(this.factory);
            this.channel = this.createChannel(this.connection);
            this.declareExchange(this.channel);
        }
        return new EventPublisherImpl(this.channel);
    }

    @Override
    public void releaseConnection() throws IOException, TimeoutException {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
        if (this.connection != null && this.connection.isOpen()) {
            this.connection.close();
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    private ConnectionFactory createConnectionFactory() {
        ConnectionFactory factory = this.factory;
        if (factory == null) {
            factory = new ConnectionFactory();
            factory.setHost(this.host);
            factory.setPort(this.port);
            factory.setVirtualHost(VIRTUAL_HOST);
            factory.setUsername(this.username);
            factory.setPassword(this.password);
        }
        return factory;
    }

    private Connection createConnection(ConnectionFactory factory) throws IOException, TimeoutException {
        Connection connection = this.connection;
        if (connection == null || !connection.isOpen()) {
            try {
                connection = factory.newConnection();
            }
            catch (IOException e) {
                throw new IOException("Unable to create RabbitMQ connection: " + e.getMessage(), e);
            }
            catch (TimeoutException e) {
                throw new TimeoutException("Connection cannot be established: " + e.getMessage());
            }
        }
        return connection;
    }

    private Channel createChannel(Connection connection) throws IOException {
        Channel channel = this.channel;
        if (channel == null || !channel.isOpen() && connection != null && connection.isOpen()) {
            try {
                channel = connection.createChannel();
            }
            catch (IOException e) {
                throw new IOException("Unable to create RabbitMQ channel: " + e.getMessage(), e);
            }
        }
        return channel;
    }

    private void declareExchange(Channel channel) throws IOException {
        if (channel != null && channel.isOpen()) {
            try {
                HashMap<String, Integer> args = new HashMap<String, Integer>();
                args.put(TYPE, 1000);
                channel.exchangeDeclare(EXCHANGE_NAME, TYPE, false, false, args);
            }
            catch (IOException e) {
                throw new IOException("Unable to create RabbitMQ exchange: " + e.getMessage(), e);
            }
        }
    }

    private boolean initAuthProperties() {
        List<HashMap<String, String>> settings;
        HttpClient.Response<List<HashMap<String, String>>> rs;
        if (this.client != null && (rs = this.client.getToolSettings("RABBITMQ", true)).getStatus() == 200 && (settings = rs.getObject()) != null) {
            settings.forEach(this::initAuthProperty);
        }
        return this.connected;
    }

    private void initAuthProperty(HashMap<String, String> settings) {
        String settingName = settings.get("name");
        String settingValue = settings.get("value");
        switch (settingName) {
            case "RABBITMQ_HOST": {
                this.host = settingValue;
                break;
            }
            case "RABBITMQ_PORT": {
                this.port = Integer.parseInt(settingValue);
                break;
            }
            case "RABBITMQ_USER": {
                this.username = settingValue;
                break;
            }
            case "RABBITMQ_PASSWORD": {
                this.password = settingValue;
                break;
            }
            case "RABBITMQ_ENABLED": {
                this.connected = Boolean.parseBoolean(settingValue);
                break;
            }
        }
    }

    public class EventPublisherImpl
    implements EventPublisher {
        private final Channel channel;

        EventPublisherImpl(Channel channel) {
            this.channel = channel;
        }

        @Override
        public boolean publishEvent(String routingKey, String correlationId, String appId, String eventType, String payload) {
            boolean result = false;
            AMQP.BasicProperties.Builder b = new AMQP.BasicProperties().builder().appId(appId).type(eventType).correlationId(String.valueOf(correlationId)).contentType("text/json");
            try {
                this.channel.basicPublish(RabbitMQService.EXCHANGE_NAME, routingKey, b.build(), payload.getBytes());
                result = true;
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return result;
        }
    }
}

