/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.log.impl;

import com.qaprosoft.zafira.client.ZafiraSingleton;
import com.qaprosoft.zafira.log.BaseAppenderTask;
import com.qaprosoft.zafira.log.LogAppenderService;
import com.qaprosoft.zafira.log.event.AmqpService;
import com.qaprosoft.zafira.log.event.EventPublisher;
import com.qaprosoft.zafira.log.event.impl.RabbitMQService;
import com.qaprosoft.zafira.util.ConfigurationUtil;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.lang3.StringUtils;

public class LogAppenderServiceImpl
implements LogAppenderService {
    private static final ZafiraSingleton ZAFIRA_INSTANCE = ZafiraSingleton.INSTANCE;
    private static final ExecutorService threadPool = Executors.newCachedThreadPool();
    private final AmqpService amqpService = new RabbitMQService(ZAFIRA_INSTANCE.getClient());
    private EventPublisher eventPublisher;
    private String identifier;
    private boolean durable;
    private String routingKey = "";
    private boolean zafiraConnected;

    @Override
    public void append(BaseAppenderTask task) {
        task.setRoutingKey(this.routingKey);
        task.setEventPublisher(this.eventPublisher);
        task.setIdentifier(this.identifier);
        task.setZafiraConnected(this.zafiraConnected);
        threadPool.submit(task);
    }

    @Override
    public void connectZafira() throws IOException, TimeoutException {
        CombinedConfiguration config = ConfigurationUtil.getConfiguration();
        if (ZAFIRA_INSTANCE.isRunning()) {
            this.routingKey = this.getRoutingKey((ImmutableConfiguration)config);
            this.eventPublisher = this.amqpService.connect();
            this.zafiraConnected = this.amqpService.isConnected();
        }
    }

    @Override
    public void onClose() throws IOException, TimeoutException {
        if (this.amqpService != null) {
            this.amqpService.releaseConnection();
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    private String getRoutingKey(ImmutableConfiguration configuration) {
        String routingKey = configuration.getString("ci_run_id", null);
        if (StringUtils.isEmpty((CharSequence)routingKey)) {
            routingKey = UUID.randomUUID().toString();
            ConfigurationUtil.addSystemConfiguration("ci_run_id", routingKey);
        }
        return routingKey;
    }
}

