/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.log.log4j;

import com.qaprosoft.zafira.listener.ZafiraEventRegistrar;
import com.qaprosoft.zafira.log.BaseAppenderTask;
import com.qaprosoft.zafira.log.domain.MetaInfoMessage;
import com.qaprosoft.zafira.log.log4j.level.MetaInfoLevel;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class AppenderTask
extends BaseAppenderTask<LoggingEvent> {
    private final Layout layout;
    private final LoggingEvent loggingEvent;

    AppenderTask(LoggingEvent loggingEvent, Layout layout) {
        this.loggingEvent = loggingEvent;
        this.layout = layout;
    }

    @Override
    protected LoggingEvent getEventObject() {
        return this.loggingEvent;
    }

    @Override
    protected String getTestId() {
        boolean isMetaInfoLevel = this.loggingEvent.getLevel().equals((Object)MetaInfoLevel.META_INFO);
        String result = isMetaInfoLevel && ((MetaInfoMessage)this.loggingEvent.getMessage()).getHeaders().get("CI_TEST_ID") != null ? ((MetaInfoMessage)this.loggingEvent.getMessage()).getHeaders().get("CI_TEST_ID") : ZafiraEventRegistrar.getThreadCiTestId();
        return result;
    }

    @Override
    protected String getJsonPayload() {
        return this.layout.format(this.loggingEvent);
    }

    @Override
    protected String getEventType() {
        return this.loggingEvent.getLevel().toString();
    }
}

