/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.log.log4j;

import com.qaprosoft.zafira.log.LogAppenderService;
import com.qaprosoft.zafira.log.impl.LogAppenderServiceImpl;
import com.qaprosoft.zafira.log.log4j.AppenderTask;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class LogAppender
extends AppenderSkeleton {
    private final LogAppenderService logAppenderService = new LogAppenderServiceImpl();
    private int history = 1000;

    public LogAppender() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::onShutdownHook));
    }

    protected void append(LoggingEvent loggingEvent) {
        if (this.isAsSevereAsThreshold((Priority)loggingEvent.getLevel())) {
            AppenderTask task = new AppenderTask(loggingEvent, this.layout);
            this.logAppenderService.append(task);
        }
    }

    public void activateOptions() {
        super.activateOptions();
        try {
            this.logAppenderService.connectZafira();
        }
        catch (IOException | TimeoutException e) {
            this.errorHandler.error(e.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
    }

    private void onShutdownHook() {
        try {
            this.logAppenderService.onClose();
        }
        catch (IOException | TimeoutException e) {
            this.errorHandler.error(e.getMessage(), e, 3);
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public int getHistory() {
        return this.history;
    }

    public void setHistory(int history) {
        this.history = history;
    }
}

